/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.idp.saml.nameid.PersistentIdEntry;
import net.shibboleth.idp.saml.nameid.PersistentIdStore;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPersistentIdDecoder
extends AbstractIdentifiableInitializableComponent
implements NameIDDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredPersistentIdDecoder.class);
    @NonnullAfterInit
    private PersistentIdStore idStore;

    @NonnullAfterInit
    public PersistentIdStore getPersistentIdStore() {
        return this.idStore;
    }

    public void setPersistentIdStore(@Nonnull PersistentIdStore store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore = (PersistentIdStore)Constraint.isNotNull((Object)store, (String)"PersistentIdStore cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.idStore) {
            throw new ComponentInitializationException("PersistentIdStore cannot be null");
        }
    }

    @Nonnull
    @NotEmpty
    public String decode(@Nonnull SubjectCanonicalizationContext c14nContext, @Nonnull NameID nameID) throws NameDecoderException {
        PersistentIdEntry entry;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (nameID.getValue() == null) {
            throw new NameDecoderException("Persistent NameID was empty");
        }
        String recipientID = nameID.getSPNameQualifier();
        if (recipientID == null && (recipientID = c14nContext.getRequesterId()) == null) {
            throw new NameDecoderException("SPNameQualifier and requester ID were null");
        }
        String issuerID = nameID.getNameQualifier();
        if (issuerID == null && (issuerID = c14nContext.getResponderId()) == null) {
            throw new NameDecoderException("NameQualifier and responder ID were null");
        }
        try {
            entry = this.idStore.getActiveEntry(nameID.getValue());
            if (entry == null) {
                this.log.info("No entry found for persistent ID {}", (Object)nameID.getValue());
                return null;
            }
        }
        catch (IOException e) {
            this.log.error("I/O error looking up persistent ID", (Throwable)e);
            return null;
        }
        if (!recipientID.equals(entry.getRecipientEntityId())) {
            this.log.warn("{} Persistent identifier issued to {} but requested by {}", (Object)entry.getRecipientEntityId(), (Object)recipientID);
            throw new NameDecoderException("Misuse of identifier by an improper relying party");
        }
        if (!issuerID.equals(entry.getIssuerEntityId())) {
            this.log.warn("{} Persistent identifier issued by {} but requested from {}", (Object)entry.getIssuerEntityId(), (Object)issuerID);
            throw new NameDecoderException("Misuse of identifier issued by somebody else");
        }
        return entry.getPrincipalName();
    }
}

