/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.saml.attribute.resolver.impl.AbstractPersistentIdDataConnector;
import net.shibboleth.idp.saml.nameid.impl.ComputedPersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedIDDataConnector
extends AbstractPersistentIdDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedIDDataConnector.class);
    @Nonnull
    private final ComputedPersistentIdGenerationStrategy idStrategy = new ComputedPersistentIdGenerationStrategy();

    @Nonnull
    public ComputedPersistentIdGenerationStrategy getComputedIdStrategy() {
        return this.idStrategy;
    }

    @Nullable
    public byte[] getSalt() {
        return this.idStrategy.getSalt();
    }

    public void setSalt(@Nullable byte[] salt) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStrategy.setSalt(salt);
    }

    public void setAlgorithm(@Nonnull @NotEmpty String alg) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStrategy.setAlgorithm(alg);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.idStrategy.initialize();
    }

    protected void doDestroy() {
        this.idStrategy.destroy();
        super.doDestroy();
    }

    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        String principalName = resolutionContext.getPrincipal();
        if (Strings.isNullOrEmpty((String)principalName)) {
            this.log.warn("{} No principal name located, unable to compute ID", (Object)this.getLogPrefix());
            return null;
        }
        String attributeIssuerId = resolutionContext.getAttributeIssuerID();
        if (Strings.isNullOrEmpty((String)attributeIssuerId)) {
            this.log.warn("{} No Attribute issuer ID located, unable to compute ID", (Object)this.getLogPrefix());
            return null;
        }
        String attributeRecipientID = resolutionContext.getAttributeRecipientID();
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            this.log.warn("{} No Attribute Recipient ID located, unable to compute ID", (Object)this.getLogPrefix());
            return null;
        }
        String sourceId = this.resolveSourceAttribute(workContext);
        if (Strings.isNullOrEmpty((String)sourceId)) {
            return null;
        }
        try {
            return this.encodeAsAttribute(this.idStrategy.generate(attributeIssuerId, attributeRecipientID, principalName, sourceId));
        }
        catch (SAMLException e) {
            throw new ResolutionException((Exception)((Object)e));
        }
    }
}

