/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding.impl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAML2NameIDEncoder;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2StringNameIDEncoder
extends AbstractSAML2NameIDEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2StringNameIDEncoder.class);
    @Nonnull
    private final SAMLObjectBuilder<NameID> identifierBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
    @Nullable
    private String format;
    @Nullable
    private String qualifier;

    public SAML2StringNameIDEncoder() {
        if (this.identifierBuilder == null) {
            throw new ConstraintViolationException("Builder unavailable for NameID objects");
        }
        this.setNameFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
    }

    @Nullable
    public final String getNameFormat() {
        return this.format;
    }

    public final void setNameFormat(@Nullable String nameFormat) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.format = StringSupport.trimOrNull((String)nameFormat);
    }

    @Nullable
    public final String getNameQualifier() {
        return this.qualifier;
    }

    @Nullable
    public final void setNameQualifier(String nameQualifier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.qualifier = StringSupport.trimOrNull((String)nameQualifier);
    }

    public boolean apply(String input) {
        return SAML2ObjectSupport.areNameIDFormatsEquivalent((String)input, (String)this.format);
    }

    @Nonnull
    public NameID encode(@Nonnull IdPAttribute attribute) throws AttributeEncodingException {
        String attributeId = attribute.getId();
        List attributeValues = attribute.getValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            throw new AttributeEncodingException("Attribute " + attribute.getId() + " does not contain any values to encode");
        }
        NameID nameId = (NameID)this.identifierBuilder.buildObject();
        nameId.setFormat(this.format);
        nameId.setNameQualifier(this.qualifier);
        for (IdPAttributeValue attrValue : attributeValues) {
            if (attrValue == null || attrValue.getValue() == null) {
                this.log.debug("Skipping null value of attribute {}", (Object)attributeId);
                continue;
            }
            Object value = attrValue.getValue();
            if (value instanceof String) {
                nameId.setValue((String)value);
                return nameId;
            }
            this.log.debug("Skipping unsupported value of type {} of attribute {}", (Object)value.getClass().getName(), (Object)attributeId);
        }
        throw new AttributeEncodingException("Attribute '" + attributeId + "' did not contain any encodable values");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SAML2StringNameIDEncoder)) {
            return false;
        }
        SAML2StringNameIDEncoder other = (SAML2StringNameIDEncoder)((Object)obj);
        return Objects.equals(this.getNameFormat(), other.getNameFormat()) && Objects.equals(this.getNameQualifier(), other.getNameQualifier());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getNameFormat(), this.getNameQualifier(), this.getProtocol(), SAML2StringNameIDEncoder.class});
    }
}

