/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ArtifactAwareProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class BrowserSSOProfileConfiguration
extends AbstractSAML2ArtifactAwareProfileConfiguration
implements AuthenticationProfileConfiguration {
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/sso/browser";
    public static final int FEATURE_AUTHNCONTEXT = 1;
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> includeAttributeStatementPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> skipEndpointValidationWhenSignedPredicate;
    @Nullable
    private Function<ProfileRequestContext, Long> maximumSPSessionLifetimeLookupStrategy;
    @Duration
    @NonNegative
    private long maximumSPSessionLifetime;
    @Nonnull
    private Predicate<ProfileRequestContext> allowDelegationPredicate;
    @Nullable
    private Function<ProfileRequestContext, Long> maximumTokenDelegationChainLengthLookupStrategy;
    @NonNegative
    private long maximumTokenDelegationChainLength;
    @Nullable
    private Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> defaultAuthenticationContextsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<AuthnContextClassRefPrincipal> defaultAuthenticationContexts;
    @Nullable
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private Set<String> authenticationFlows;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> postAuthenticationFlows;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> nameIDFormatPrecedenceLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> nameIDFormatPrecedence;

    public BrowserSSOProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses((Predicate<ProfileRequestContext>)Predicates.alwaysTrue());
        this.setEncryptAssertions((Predicate<ProfileRequestContext>)Predicates.alwaysTrue());
        this.resolveAttributesPredicate = Predicates.alwaysTrue();
        this.includeAttributeStatementPredicate = Predicates.alwaysTrue();
        this.forceAuthnPredicate = Predicates.alwaysFalse();
        this.skipEndpointValidationWhenSignedPredicate = Predicates.alwaysFalse();
        this.maximumSPSessionLifetime = 0L;
        this.maximumTokenDelegationChainLength = 1L;
        this.allowDelegationPredicate = Predicates.alwaysFalse();
        this.defaultAuthenticationContexts = Collections.emptyList();
        this.authenticationFlows = Collections.emptySet();
        this.postAuthenticationFlows = Collections.emptyList();
        this.nameIDFormatPrecedence = Collections.emptyList();
    }

    @Deprecated
    public boolean resolveAttributes() {
        return this.resolveAttributesPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getResolveAttributesPredicate() {
        return this.resolveAttributesPredicate;
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    @Deprecated
    public boolean includeAttributeStatement() {
        return this.includeAttributeStatementPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setIncludeAttributeStatement(boolean include) {
        this.includeAttributeStatementPredicate = include ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getIncludeAttributeStatementPredicate() {
        return this.includeAttributeStatementPredicate;
    }

    public void setIncludeAttributeStatementPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeAttributeStatementPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Include attribute statement predicate cannot be null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getForceAuthnPredicate() {
        return this.forceAuthnPredicate;
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Deprecated
    public boolean skipEndpointValidationWhenSigned() {
        return this.skipEndpointValidationWhenSignedPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setSkipEndpointValidationWhenSigned(boolean skip) {
        this.skipEndpointValidationWhenSignedPredicate = skip ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getSkipEndpointValidationWhenSignedPredicate() {
        return this.skipEndpointValidationWhenSignedPredicate;
    }

    public void setSkipEndpointValidationWhenSignedPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.skipEndpointValidationWhenSignedPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Skip endpoint validation predicate cannot be null");
    }

    @Duration
    @NonNegative
    public long getMaximumSPSessionLifetime() {
        return Constraint.isGreaterThanOrEqual((long)0L, (long)((Long)this.getIndirectProperty(this.maximumSPSessionLifetimeLookupStrategy, this.maximumSPSessionLifetime)), (String)"Maximum SP session lifetime must be greater or equal to 0");
    }

    @Duration
    public void setMaximumSPSessionLifetime(@Duration @NonNegative long lifetime) {
        this.maximumSPSessionLifetime = Constraint.isGreaterThanOrEqual((long)0L, (long)lifetime, (String)"Maximum SP session lifetime must be greater than or equal to 0");
    }

    public void setMaximumSPSessionLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        this.maximumSPSessionLifetimeLookupStrategy = strategy;
    }

    @Deprecated
    public Boolean getAllowingDelegation() {
        return this.allowDelegationPredicate.apply((Object)this.getProfileRequestContext());
    }

    @Deprecated
    public void setAllowingDelegation(Boolean isAllowed) {
        this.allowDelegationPredicate = isAllowed != null ? (isAllowed != false ? Predicates.alwaysTrue() : Predicates.alwaysFalse()) : Predicates.alwaysFalse();
    }

    public boolean isAllowingDelegation() {
        return this.allowDelegationPredicate.apply((Object)this.getProfileRequestContext());
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getAllowDelegation() {
        return this.allowDelegationPredicate;
    }

    public void setAllowDelegation(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.allowDelegationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Allow delegation predicate cannot be null");
    }

    @NonNegative
    public long getMaximumTokenDelegationChainLength() {
        return Constraint.isGreaterThanOrEqual((long)0L, (long)((Long)this.getIndirectProperty(this.maximumTokenDelegationChainLengthLookupStrategy, this.maximumTokenDelegationChainLength)), (String)"Delegation chain length must be greater than or equal to 0");
    }

    public void setMaximumTokenDelegationChainLength(@NonNegative long length) {
        this.maximumTokenDelegationChainLength = Constraint.isGreaterThanOrEqual((long)0L, (long)length, (String)"Delegation chain length must be greater than or equal to 0");
    }

    public void setMaximumTokenDelegationChainLengthLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        this.maximumTokenDelegationChainLengthLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.defaultAuthenticationContextsLookupStrategy, this.defaultAuthenticationContexts)));
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthnContextClassRefPrincipal> contexts) {
        this.defaultAuthenticationContexts = contexts != null ? new ArrayList<AuthnContextClassRefPrincipal>(Collections2.filter(contexts, (Predicate)Predicates.notNull())) : Collections.emptyList();
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows() {
        return ImmutableSet.copyOf((Collection)((Collection)this.getIndirectProperty(this.authenticationFlowsLookupStrategy, this.authenticationFlows)));
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlows = flows != null ? new HashSet<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptySet();
    }

    public void setAuthenticationFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.postAuthenticationFlowsLookupStrategy, this.postAuthenticationFlows)));
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlows = flows != null ? new ArrayList<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptyList();
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.nameIDFormatPrecedenceLookupStrategy, this.nameIDFormatPrecedence)));
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements Collection<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = new ArrayList<String>(StringSupport.normalizeStringCollection(formats));
    }

    public void setNameIDFormatPrecedenceLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.nameIDFormatPrecedenceLookupStrategy = strategy;
    }
}

