/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session;

import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAML2SPSessionTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void testInstantiation() throws Exception {
        NameID nameID = (NameID)XMLObjectSupport.buildXMLObject((QName)NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue("joe@example.org");
        nameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        long start = System.currentTimeMillis();
        Thread.sleep(50L);
        SAML2SPSession session = new SAML2SPSession("test", System.currentTimeMillis(), System.currentTimeMillis() + 60000L, nameID, "1234567890");
        Assert.assertEquals((String)session.getId(), (String)"test");
        Assert.assertTrue((session.getCreationInstant() > start ? 1 : 0) != 0);
        Assert.assertTrue((session.getExpirationInstant() > session.getCreationInstant() ? 1 : 0) != 0);
        Assert.assertSame((Object)session.getNameID(), (Object)nameID);
        Assert.assertEquals((String)session.getSessionIndex(), (String)"1234567890");
        Assert.assertEquals((String)session.getSPSessionKey(), (String)"joe@example.org");
        try {
            new SAML2SPSession(null, 0L, 0L, null, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("", 0L, 0L, null, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("  ", 0L, 0L, null, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", 0L, 0L, null, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", start, 0L, null, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", start, start, null, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", start, start, nameID, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

