/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.profile.config.BasicSAMLArtifactConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrowserSSOProfileConfigurationTest {
    @Test
    public void testProfileId() {
        Assert.assertEquals((String)"http://shibboleth.net/ns/profiles/saml2/sso/browser", (String)"http://shibboleth.net/ns/profiles/saml2/sso/browser");
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertEquals((String)config.getId(), (String)"http://shibboleth.net/ns/profiles/saml2/sso/browser");
    }

    @Test
    public void testResolveAttributes() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.resolveAttributes());
        config.setResolveAttributes(false);
        Assert.assertFalse((boolean)config.resolveAttributes());
    }

    @Test
    public void testIndirectResolveAttributes() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setResolveAttributesPredicate(Predicates.alwaysFalse());
        Assert.assertFalse((boolean)config.resolveAttributes());
    }

    @Test
    public void testIncludeAttributeStatement() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.includeAttributeStatement());
        config.setIncludeAttributeStatement(false);
        Assert.assertFalse((boolean)config.includeAttributeStatement());
    }

    @Test
    public void testIndirectIncludeAttributeStatement() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setIncludeAttributeStatementPredicate(Predicates.alwaysFalse());
        Assert.assertFalse((boolean)config.includeAttributeStatement());
    }

    @Test
    public void testSkipEndpointValidationWhenSigned() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertFalse((boolean)config.skipEndpointValidationWhenSigned());
        config.setSkipEndpointValidationWhenSigned(true);
        Assert.assertTrue((boolean)config.skipEndpointValidationWhenSigned());
    }

    @Test
    public void testIndirectEndpointValidationWhenSigned() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setSkipEndpointValidationWhenSignedPredicate(Predicates.alwaysTrue());
        Assert.assertTrue((boolean)config.skipEndpointValidationWhenSigned());
    }

    @Test
    public void testMaximumSPSessionLifeTime() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertEquals((long)config.getMaximumSPSessionLifetime(), (long)0L);
        config.setMaximumSPSessionLifetime(1000L);
        Assert.assertEquals((long)config.getMaximumSPSessionLifetime(), (long)1000L);
    }

    @Test
    public void testIndirectMaximumSPSessionLifeTime() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setMaximumSPSessionLifetimeLookupStrategy(FunctionSupport.constant((Object)1000L));
        Assert.assertEquals((long)config.getMaximumSPSessionLifetime(), (long)1000L);
    }

    @Test
    public void testAllowingDelegation() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertFalse((boolean)config.isAllowingDelegation());
        Assert.assertFalse((boolean)config.getAllowingDelegation());
        config.setAllowingDelegation(Boolean.valueOf(false));
        Assert.assertFalse((boolean)config.isAllowingDelegation());
        Assert.assertFalse((boolean)config.getAllowingDelegation());
        Assert.assertEquals((Object)config.getAllowingDelegation(), (Object)Boolean.FALSE);
        config.setAllowingDelegation(Boolean.valueOf(true));
        Assert.assertTrue((boolean)config.isAllowingDelegation());
        Assert.assertTrue((boolean)config.getAllowingDelegation());
        Assert.assertEquals((Object)config.getAllowingDelegation(), (Object)Boolean.TRUE);
    }

    @Test
    public void testAllowDelegation() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertNotNull((Object)config.getAllowDelegation());
        Predicate predicate = Predicates.alwaysTrue();
        config.setAllowDelegation(predicate);
        Assert.assertSame((Object)config.getAllowDelegation(), (Object)predicate);
        try {
            config.setAllowDelegation(null);
            Assert.fail((String)"Null predicate should not have been allowed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testMaximumTokenDelegationChainLength() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertEquals((long)config.getMaximumTokenDelegationChainLength(), (long)1L);
        config.setMaximumTokenDelegationChainLength(10L);
        Assert.assertEquals((long)config.getMaximumTokenDelegationChainLength(), (long)10L);
    }

    @Test
    public void testIndirectMaximumTokenDelegationChainLength() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setMaximumTokenDelegationChainLengthLookupStrategy(FunctionSupport.constant((Object)10L));
        Assert.assertEquals((long)config.getMaximumTokenDelegationChainLength(), (long)10L);
    }

    @Test
    public void testArtifactConfiguration() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertNull((Object)config.getArtifactConfiguration());
        BasicSAMLArtifactConfiguration artifactConfiguration = new BasicSAMLArtifactConfiguration();
        config.setArtifactConfiguration((SAMLArtifactConfiguration)artifactConfiguration);
        Assert.assertSame((Object)config.getArtifactConfiguration(), (Object)artifactConfiguration);
    }

    @Test
    public void testIndirectArtifactConfiguration() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        BasicSAMLArtifactConfiguration artifactConfiguration = new BasicSAMLArtifactConfiguration();
        config.setArtifactConfigurationLookupStrategy(FunctionSupport.constant((Object)artifactConfiguration));
        Assert.assertSame((Object)config.getArtifactConfiguration(), (Object)artifactConfiguration);
    }

    @Test
    public void testDefaultAuthenticationMethods() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getDefaultAuthenticationMethods().isEmpty());
        ArrayList<AuthnContextClassRefPrincipal> principals = new ArrayList<AuthnContextClassRefPrincipal>();
        principals.add(new AuthnContextClassRefPrincipal("foo"));
        principals.add(new AuthnContextClassRefPrincipal("bar"));
        config.setDefaultAuthenticationMethods(principals);
        Assert.assertEquals((Collection)config.getDefaultAuthenticationMethods(), principals);
    }

    @Test
    public void testIndirectDefaultAuthenticationMethods() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<AuthnContextClassRefPrincipal> principals = new ArrayList<AuthnContextClassRefPrincipal>();
        principals.add(new AuthnContextClassRefPrincipal("foo"));
        principals.add(new AuthnContextClassRefPrincipal("bar"));
        config.setDefaultAuthenticationMethodsLookupStrategy(FunctionSupport.constant(principals));
        Assert.assertEquals((Collection)config.getDefaultAuthenticationMethods(), principals);
    }

    @Test
    public void testAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getAuthenticationFlows().isEmpty());
        HashSet<String> flows = new HashSet<String>();
        flows.add("foo");
        flows.add("bar");
        config.setAuthenticationFlows(flows);
        Assert.assertEquals((Set)config.getAuthenticationFlows(), flows);
    }

    @Test
    public void testIndirectAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        HashSet<String> flows = new HashSet<String>();
        flows.add("foo");
        flows.add("bar");
        config.setAuthenticationFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Set)config.getAuthenticationFlows(), flows);
    }

    @Test
    public void testPostAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getPostAuthenticationFlows().isEmpty());
        ArrayList<String> flows = new ArrayList<String>();
        flows.add("foo");
        flows.add("bar");
        config.setPostAuthenticationFlows(flows);
        Assert.assertEquals((Collection)config.getPostAuthenticationFlows(), flows);
    }

    @Test
    public void testIndirectPostAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<String> flows = new ArrayList<String>();
        flows.add("foo");
        flows.add("bar");
        config.setPostAuthenticationFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Collection)config.getPostAuthenticationFlows(), flows);
    }

    @Test
    public void testNameIDFormatPrecedence() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getNameIDFormatPrecedence().isEmpty());
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("foo");
        formats.add("bar");
        config.setNameIDFormatPrecedence(formats);
        Assert.assertEquals((Collection)config.getNameIDFormatPrecedence(), formats);
    }

    @Test
    public void testIndirectNameIDFormatPrecedence() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("foo");
        formats.add("bar");
        config.setNameIDFormatPrecedenceLookupStrategy(FunctionSupport.constant(formats));
        Assert.assertEquals((Collection)config.getNameIDFormatPrecedence(), formats);
    }

    @Test
    public void testSignArtifactRequests() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setSignArtifactRequests(Predicates.alwaysTrue());
        Assert.assertSame((Object)config.getSignArtifactRequests(), (Object)Predicates.alwaysTrue());
    }

    @Test
    public void testClientTLSArtifactRequests() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setClientTLSArtifactRequests(Predicates.alwaysTrue());
        Assert.assertSame((Object)config.getClientTLSArtifactRequests(), (Object)Predicates.alwaysTrue());
    }
}

