/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractSAML2ProfileConfigurationTest {
    @Test
    public void testEncryptionOptional() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertFalse((boolean)config.isEncryptionOptional());
        config.setEncryptionOptional(true);
        Assert.assertTrue((boolean)config.isEncryptionOptional());
    }

    @Test
    public void testIndirectEncryptionOptional() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        config.setEncryptionOptionalPredicate(Predicates.alwaysTrue());
        Assert.assertTrue((boolean)config.isEncryptionOptional());
    }

    @Test
    public void testEncryptNameIDsPredicate() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertNotNull((Object)config.getEncryptNameIDs());
        config.setEncryptNameIDs(Predicates.alwaysFalse());
        Assert.assertSame((Object)config.getEncryptNameIDs(), (Object)Predicates.alwaysFalse());
        try {
            config.setEncryptNameIDs(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptAssertionsPredicate() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertNotNull((Object)config.getEncryptAssertions());
        config.setEncryptAssertions(Predicates.alwaysFalse());
        Assert.assertSame((Object)config.getEncryptAssertions(), (Object)Predicates.alwaysFalse());
        try {
            config.setEncryptAssertions(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptAttributesPredicate() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertNotNull((Object)config.getEncryptAttributes());
        config.setEncryptAttributes(Predicates.alwaysFalse());
        Assert.assertSame((Object)config.getEncryptAttributes(), (Object)Predicates.alwaysFalse());
        try {
            config.setEncryptAttributes(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyCount() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertEquals((long)config.getProxyCount(), (long)0L);
        config.setProxyCount(1L);
        Assert.assertEquals((long)config.getProxyCount(), (long)1L);
    }

    @Test
    public void testIndirectProxyCount() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        config.setProxyCountLookupStrategy(FunctionSupport.constant((Object)1L));
        Assert.assertEquals((long)config.getProxyCount(), (long)1L);
    }

    @Test
    public void testProxyAudiences() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertNotNull((Object)config.getProxyAudiences());
        Assert.assertTrue((boolean)config.getProxyAudiences().isEmpty());
        ArrayList<String> audiences = new ArrayList<String>();
        audiences.add("foo");
        audiences.add("foo");
        audiences.add("bar");
        config.setProxyAudiences(audiences);
        Assert.assertNotSame((Object)config.getProxyAudiences(), audiences);
        Assert.assertEquals((Collection)config.getProxyAudiences(), audiences);
        try {
            config.getProxyAudiences().add("baz");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testIndirectProxyAudiences() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        ArrayList<String> audiences = new ArrayList<String>();
        audiences.add("foo");
        audiences.add("foo");
        audiences.add("bar");
        config.setProxyAudiencesLookupStrategy(FunctionSupport.constant(audiences));
        Assert.assertNotSame((Object)config.getProxyAudiences(), audiences);
        Assert.assertEquals((Collection)config.getProxyAudiences(), audiences);
        try {
            config.getProxyAudiences().add("baz");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static class MockSAML2ProfileConfiguration
    extends AbstractSAML2ProfileConfiguration {
        public MockSAML2ProfileConfiguration() {
            super("mock");
        }
    }
}

