/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAML1AttributeEncoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml1.core.Attribute;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AbstractSAMLAttributeEncoderTest
extends OpenSAMLInitBaseTestCase {
    private XMLObjectBuilder<XSString> theBuilder;
    private QName theQName = new QName("LocalQNAME");
    private final String MY_NAME = "myName";
    private final String MY_NAMESPACE = "myNameSpace";
    private final String ATTRIBUTE_ID = "attrID";
    private final String ATTRIBUTE_VALUE_1 = "attrValOne";
    private final String ATTRIBUTE_VALUE_2 = "attrValeTwo";

    @BeforeClass
    public void initTest() throws ComponentInitializationException {
        this.theBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
    }

    @Test
    public void initializeAndSetters() throws AttributeEncodingException, ComponentInitializationException {
        mockEncoder encoder = new mockEncoder(this.theBuilder, this.theQName);
        Assert.assertNull((Object)encoder.getName());
        Assert.assertEquals((String)encoder.getNamespace(), (String)"urn:mace:shibboleth:1.0:attributeNamespace:uri");
        try {
            encoder.setName("");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        encoder = new mockEncoder(this.theBuilder, this.theQName);
        try {
            encoder.setNamespace("");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        encoder = new mockEncoder(this.theBuilder, this.theQName);
        encoder.setNamespace("myNameSpace");
        encoder.setName("myName");
        try {
            encoder.encode(new IdPAttribute("attrID"));
            Assert.fail();
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        encoder.initialize();
        try {
            encoder.setName(" ");
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        try {
            encoder.setNamespace(" ");
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
    }

    @Test
    public void encode() throws AttributeEncodingException, ComponentInitializationException {
        mockEncoder encoder = new mockEncoder(this.theBuilder, this.theQName);
        encoder.setNamespace("myNameSpace");
        encoder.setName("myName");
        encoder.initialize();
        IdPAttribute attr = new IdPAttribute("attrID");
        try {
            encoder.encode(attr);
        }
        catch (AttributeEncodingException attributeEncodingException) {
            // empty catch block
        }
        final int[] intArray = new int[]{1, 2, 3, 4};
        ArrayList<IdPAttributeValue> values = new ArrayList<IdPAttributeValue>(Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), null, new IdPAttributeValue<Object>(){

            public Object getValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        }));
        attr.setValues(values);
        try {
            encoder.encode(attr);
        }
        catch (AttributeEncodingException attributeEncodingException) {
            // empty catch block
        }
        values.add((IdPAttributeValue)new StringAttributeValue("attrValOne"));
        values.add((IdPAttributeValue)new StringAttributeValue("attrValeTwo"));
        attr.setValues(values);
        List result = ((Attribute)encoder.encode(attr)).getAttributeValues();
        Assert.assertEquals((int)result.size(), (int)2);
        HashSet<String> resultSet = new HashSet<String>(2);
        for (XMLObject o : result) {
            Assert.assertTrue((boolean)(o instanceof XSString));
            resultSet.add(((XSString)o).getValue());
        }
        Assert.assertTrue((boolean)resultSet.contains("attrValOne"));
        Assert.assertTrue((boolean)resultSet.contains("attrValeTwo"));
    }

    @Test
    public void equalsHash() {
        mockEncoder enc1 = new mockEncoder(this.theBuilder, this.theQName);
        Assert.assertEquals((Object)((Object)enc1), (Object)((Object)enc1));
        Assert.assertNotSame((Object)((Object)enc1), null);
        Assert.assertNotSame((Object)((Object)enc1), (Object)((Object)this));
        mockEncoder enc2 = new mockEncoder(this.theBuilder, this.theQName);
        Assert.assertEquals((Object)((Object)enc1), (Object)((Object)enc2));
        Assert.assertEquals((int)enc1.hashCode(), (int)enc2.hashCode());
        enc1.setName("myName");
        enc1.setNamespace("myNameSpace");
        enc2.setName("myName");
        enc2.setNamespace("myNameSpace");
        Assert.assertEquals((Object)((Object)enc1), (Object)((Object)enc2));
        Assert.assertEquals((int)enc1.hashCode(), (int)enc2.hashCode());
        enc2.setName("myNamemyName");
        Assert.assertNotSame((Object)((Object)enc1), (Object)((Object)enc2));
        Assert.assertNotSame((Object)enc1.hashCode(), (Object)enc2.hashCode());
        enc2.setName("myName");
        enc2.setNamespace("myName");
        Assert.assertNotSame((Object)((Object)enc1), (Object)((Object)enc2));
        Assert.assertNotSame((Object)enc1.hashCode(), (Object)enc2.hashCode());
    }

    protected static class mockEncoder
    extends AbstractSAML1AttributeEncoder {
        @Nonnull
        private final XMLObjectBuilder<XSString> builder;
        @Nonnull
        private final QName myQName;

        public mockEncoder(@Nonnull XMLObjectBuilder<XSString> theBuilder, @Nonnull QName theQName) {
            this.builder = theBuilder;
            this.myQName = theQName;
        }

        protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
            return !(value instanceof ByteAttributeValue);
        }

        @Nullable
        protected XMLObject encodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) throws AttributeEncodingException {
            if (!(value instanceof StringAttributeValue)) {
                return null;
            }
            XSString result = (XSString)this.builder.buildObject(this.myQName);
            result.setValue((String)value.getValue());
            return result;
        }
    }
}

