/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAMLAttributeEncoderTest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Attribute;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AbstractSAML1AttributeEncoderTest
extends OpenSAMLInitBaseTestCase {
    private XMLObjectBuilder<XSString> theBuilder;
    private QName theQName = new QName("LocalQNAME");
    private final String MY_NAME = "myName";
    private final String MY_NAMESPACE = "myNameSpace";
    private final String ATTRIBUTE_ID = "attrID";
    private final String ATTRIBUTE_VALUE_1 = "attrValOne";
    private final String ATTRIBUTE_VALUE_2 = "attrValueTwo";

    @BeforeClass
    public void initTest() throws ComponentInitializationException {
        this.theBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
    }

    @Test
    public void abstractSAML1AttributeEncoder() throws ComponentInitializationException, AttributeEncodingException {
        AbstractSAMLAttributeEncoderTest.mockEncoder encoder = new AbstractSAMLAttributeEncoderTest.mockEncoder(this.theBuilder, this.theQName);
        encoder.setName("myName");
        encoder.setNamespace("myNameSpace");
        encoder.initialize();
        Assert.assertEquals((String)encoder.getProtocol(), (String)"urn:oasis:names:tc:SAML:1.1:protocol");
        IdPAttribute attr = new IdPAttribute("attrID");
        attr.setValues(Arrays.asList(new StringAttributeValue("attrValOne"), new StringAttributeValue("attrValueTwo")));
        SAMLObject obj = encoder.encode(attr);
        Assert.assertTrue((boolean)(obj instanceof Attribute));
        List result = ((Attribute)obj).getAttributeValues();
        Assert.assertEquals((int)result.size(), (int)2);
        HashSet<String> resultSet = new HashSet<String>(2);
        for (XMLObject o : result) {
            Assert.assertTrue((boolean)(o instanceof XSString));
            resultSet.add(((XSString)o).getValue());
        }
        Assert.assertTrue((boolean)resultSet.contains("attrValOne"));
        Assert.assertTrue((boolean)resultSet.contains("attrValueTwo"));
    }
}

