/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConsumerProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ArtifactAwareProfileConfiguration
extends AbstractSAML2ProfileConfiguration
implements SAMLArtifactAwareProfileConfiguration,
SAMLArtifactConsumerProfileConfiguration {
    @Nullable
    private SAMLArtifactConfiguration artifactConfiguration;
    @Nullable
    private Function<ProfileRequestContext, SAMLArtifactConfiguration> artifactConfigurationLookupStrategy;
    @Nonnull
    private Predicate<MessageContext> signArtifactRequestsPredicate = new NoIntegrityMessageChannelPredicate();
    @Nonnull
    private Predicate<MessageContext> clientTLSArtifactRequestsPredicate = Predicates.not((Predicate)new NoIntegrityMessageChannelPredicate());

    protected AbstractSAML2ArtifactAwareProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    @Nullable
    public SAMLArtifactConfiguration getArtifactConfiguration() {
        return (SAMLArtifactConfiguration)this.getIndirectProperty(this.artifactConfigurationLookupStrategy, this.artifactConfiguration);
    }

    public void setArtifactConfiguration(@Nullable SAMLArtifactConfiguration config) {
        this.artifactConfiguration = config;
    }

    public void setArtifactConfigurationLookupStrategy(@Nullable Function<ProfileRequestContext, SAMLArtifactConfiguration> strategy) {
        this.artifactConfigurationLookupStrategy = strategy;
    }

    @Override
    public Predicate<MessageContext> getSignArtifactRequests() {
        return this.signArtifactRequestsPredicate;
    }

    public void setSignArtifactRequests(@Nonnull Predicate<MessageContext> predicate) {
        this.signArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact request signing may not be null");
    }

    @Override
    public Predicate<MessageContext> getClientTLSArtifactRequests() {
        return this.clientTLSArtifactRequestsPredicate;
    }

    public void setClientTLSArtifactRequests(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact client TLS use may not be null");
    }
}

