/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.logic;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;

public class SignAssertionsPredicate
extends AbstractRelyingPartyPredicate {
    private boolean honorMetadata = true;
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new SAMLMetadataContextLookupFunction();

    public void setHonorMetadata(boolean flag) {
        this.honorMetadata = flag;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        ProfileConfiguration pc;
        Boolean flag;
        SAMLMetadataContext metadataCtx;
        if (this.honorMetadata && (metadataCtx = (SAMLMetadataContext)this.metadataContextLookupStrategy.apply((Object)input)) != null && metadataCtx.getRoleDescriptor() != null && metadataCtx.getRoleDescriptor() instanceof SPSSODescriptor && (flag = ((SPSSODescriptor)metadataCtx.getRoleDescriptor()).getWantAssertionsSigned()) != null && flag.booleanValue()) {
            return true;
        }
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply((Object)input);
        if (rpc != null && (pc = rpc.getProfileConfig()) != null && pc instanceof SAMLProfileConfiguration) {
            return ((SAMLProfileConfiguration)pc).getSignAssertions().apply((Object)input);
        }
        return false;
    }
}

