/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StringConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected String doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none");
            return null;
        }
        this.log.debug("Converting tag '{}' to String property", (Object)tag.getName());
        return this.xmlObjectToString((XMLObject)values.get(0));
    }

    @Nullable
    private String xmlObjectToString(@Nonnull XMLObject object) {
        XSAny wc;
        if (object instanceof XSString) {
            return ((XSString)object).getValue();
        }
        if (object instanceof XSURI) {
            return ((XSURI)object).getValue();
        }
        if (object instanceof XSBoolean) {
            XSBooleanValue value = ((XSBoolean)object).getValue();
            return value != null ? (value.getValue().booleanValue() ? "1" : "0") : null;
        }
        if (object instanceof XSInteger) {
            Integer value = ((XSInteger)object).getValue();
            return value != null ? value.toString() : null;
        }
        if (object instanceof XSDateTime) {
            DateTime dt = ((XSDateTime)object).getValue();
            return dt != null ? Long.toString(dt.getMillis()) : null;
        }
        if (object instanceof XSBase64Binary) {
            return ((XSBase64Binary)object).getValue();
        }
        if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            return wc.getTextContent();
        }
        this.log.error("Unsupported conversion to String from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

