/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Integer> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IntegerConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected Integer doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none");
            return null;
        }
        this.log.debug("Converting tag '{}' to Integer property", (Object)tag.getName());
        return this.xmlObjectToInteger((XMLObject)values.get(0));
    }

    @Nullable
    private Integer xmlObjectToInteger(@Nonnull XMLObject object) {
        XSAny wc;
        if (object instanceof XSString) {
            String value = ((XSString)object).getValue();
            return value != null ? Integer.decode(value) : null;
        }
        if (object instanceof XSBoolean) {
            XSBooleanValue value = ((XSBoolean)object).getValue();
            return value != null ? Integer.valueOf(value.getValue() != false ? 1 : 0) : null;
        }
        if (object instanceof XSInteger) {
            return ((XSInteger)object).getValue();
        }
        if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            String value = wc.getTextContent();
            return value != null ? Integer.decode(value) : null;
        }
        this.log.error("Unsupported conversion to Integer from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

