/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class ECPProfileConfiguration
extends BrowserSSOProfileConfiguration {
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/sso/ecp";
    @Nullable
    private Function<ProfileRequestContext, Set<String>> localEventsLookupStrategy;
    @Nonnull
    @NonnullElements
    private Set<String> localEvents;

    public ECPProfileConfiguration() {
        this(PROFILE_ID);
        this.localEvents = Collections.emptySet();
    }

    protected ECPProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getLocalEvents() {
        return ImmutableSet.copyOf((Collection)((Collection)this.getIndirectProperty(this.localEventsLookupStrategy, this.localEvents)));
    }

    public void setLocalEvents(@Nullable @NonnullElements Collection<String> events) {
        this.localEvents = events != null ? new HashSet<String>(StringSupport.normalizeStringCollection(events)) : Collections.emptySet();
    }

    public void setLocalEventsLookupStrategy(@Nullable Function<ProfileRequestContext, Set<String>> strategy) {
        this.localEventsLookupStrategy = strategy;
    }
}

