/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.saml1.profile.config.AbstractSAML1ArtifactAwareProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class BrowserSSOProfileConfiguration
extends AbstractSAML1ArtifactAwareProfileConfiguration
implements AuthenticationProfileConfiguration {
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml1/sso/browser";
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> includeAttributeStatementPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nullable
    private Function<ProfileRequestContext, Collection<AuthenticationMethodPrincipal>> defaultAuthenticationMethodsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<AuthenticationMethodPrincipal> defaultAuthenticationMethods;
    @Nullable
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private Set<String> authenticationFlows;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> postAuthenticationFlows;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> nameIDFormatPrecedenceLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> nameIDFormatPrecedence;

    public BrowserSSOProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses((Predicate<ProfileRequestContext>)Predicates.alwaysTrue());
        this.resolveAttributesPredicate = Predicates.alwaysTrue();
        this.includeAttributeStatementPredicate = Predicates.alwaysFalse();
        this.forceAuthnPredicate = Predicates.alwaysFalse();
        this.defaultAuthenticationMethods = Collections.emptyList();
        this.authenticationFlows = Collections.emptySet();
        this.postAuthenticationFlows = Collections.emptyList();
        this.nameIDFormatPrecedence = Collections.emptyList();
    }

    public boolean resolveAttributes() {
        return this.resolveAttributesPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getResolveAttributesPredicate() {
        return this.resolveAttributesPredicate;
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean includeAttributeStatement() {
        return this.includeAttributeStatementPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setIncludeAttributeStatement(boolean include) {
        this.includeAttributeStatementPredicate = include ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getIncludeAttributeStatementPredicate() {
        return this.includeAttributeStatementPredicate;
    }

    public void setIncludeAttributeStatementPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeAttributeStatementPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Include attribute statement predicate cannot be null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getForceAuthnPredicate() {
        return this.forceAuthnPredicate;
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.defaultAuthenticationMethodsLookupStrategy, this.defaultAuthenticationMethods)));
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthenticationMethodPrincipal> methods) {
        this.defaultAuthenticationMethods = methods != null ? new ArrayList<AuthenticationMethodPrincipal>(Collections2.filter(methods, (Predicate)Predicates.notNull())) : Collections.emptyList();
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<AuthenticationMethodPrincipal>> strategy) {
        this.defaultAuthenticationMethodsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows() {
        return ImmutableSet.copyOf((Collection)((Collection)this.getIndirectProperty(this.authenticationFlowsLookupStrategy, this.authenticationFlows)));
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlows = flows != null ? new HashSet<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptySet();
    }

    public void setAuthenticationFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.postAuthenticationFlowsLookupStrategy, this.postAuthenticationFlows)));
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlows = flows != null ? new ArrayList<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptyList();
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.nameIDFormatPrecedenceLookupStrategy, this.nameIDFormatPrecedence)));
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements Collection<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = new ArrayList<String>(StringSupport.normalizeStringCollection(formats));
    }

    public void setNameIDFormatPrecedenceLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.nameIDFormatPrecedenceLookupStrategy = strategy;
    }
}

