/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAMLAttributeEncoder;
import net.shibboleth.idp.saml.attribute.encoding.AttributeDesignatorMapperProcessor;
import net.shibboleth.idp.saml.attribute.encoding.SAML1AttributeEncoder;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeDesignatorMapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Attribute;

public abstract class AbstractSAML1AttributeEncoder<EncodedType extends IdPAttributeValue>
extends AbstractSAMLAttributeEncoder<Attribute, EncodedType>
implements SAML1AttributeEncoder<EncodedType>,
AttributeDesignatorMapperProcessor<IdPAttribute> {
    @Nonnull
    private final SAMLObjectBuilder<Attribute> attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Attribute.TYPE_NAME);
    @NonnullAfterInit
    private String namespace;

    public AbstractSAML1AttributeEncoder() {
        if (this.attributeBuilder == null) {
            throw new ConstraintViolationException("SAML 1 Attribute builder is unavailable");
        }
        this.namespace = "urn:mace:shibboleth:1.0:attributeNamespace:uri";
    }

    @Nonnull
    @NotEmpty
    public final String getProtocol() {
        return "urn:oasis:names:tc:SAML:1.1:protocol";
    }

    @Override
    @NonnullAfterInit
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nonnull @NotEmpty String attributeNamespace) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeNamespace), (String)"Attribute namespace cannot be null or empty");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.namespace == null) {
            throw new ComponentInitializationException("Attribute namespace cannot be null or empty");
        }
    }

    @Override
    @Nonnull
    protected Attribute buildAttribute(@Nonnull IdPAttribute idpAttribute, @Nonnull @NonnullElements List<XMLObject> attributeValues) throws AttributeEncodingException {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(this.getName());
        samlAttribute.setAttributeNamespace(this.getNamespace());
        samlAttribute.getAttributeValues().addAll(attributeValues);
        return samlAttribute;
    }

    @Override
    @Nonnull
    public void populateAttributeMapper(@Nonnull AbstractSAMLAttributeDesignatorMapper<IdPAttribute> mapper) {
        mapper.setAttributeNamespace(this.getNamespace());
        mapper.setId(this.getMapperId());
        mapper.setSAMLName(this.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractSAML1AttributeEncoder)) {
            return false;
        }
        AbstractSAML1AttributeEncoder other = (AbstractSAML1AttributeEncoder)obj;
        return Objects.equals(this.getNamespace(), other.getNamespace());
    }

    @Override
    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getNamespace()});
    }

    @Nonnull
    @NotEmpty
    private String getMapperId() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return "MapperForAttribute" + this.getName();
    }
}

