/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.logic;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.idp.saml.saml2.profile.config.ECPProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPErrorPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SOAPErrorPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpCtx = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply((Object)input);
        if (rpCtx == null) {
            this.log.debug("No RelyingPartyContext found, assuming error handled with SOAP fault");
            return true;
        }
        EventContext eventCtx = (EventContext)this.eventContextLookupStrategy.apply((Object)input);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            this.log.debug("No event found, assuming error handled with SOAP fault");
            return true;
        }
        if (rpCtx.getProfileConfig() == null || !(rpCtx.getProfileConfig() instanceof ECPProfileConfiguration)) {
            this.log.debug("No ECP profile configuration found, assuming error handled with SOAP fault");
            return true;
        }
        String event = eventCtx.getEvent().toString();
        if (((ECPProfileConfiguration)rpCtx.getProfileConfig()).getLocalEvents().contains(event)) {
            this.log.debug("Error event {} will be handled locally", (Object)event);
            return false;
        }
        this.log.debug("Error event {} will be handled with SOAP fault", (Object)event);
        return true;
    }
}

