/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.logic;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.profile.logic.MetadataNameIdentifierFormatStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNameIdentifierFormatStrategy
extends MetadataNameIdentifierFormatStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultNameIdentifierFormatStrategy.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private String profileId;
    @Nonnull
    @NotEmpty
    private String defaultFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setProfileId(@Nullable String id) {
        this.profileId = StringSupport.trimOrNull((String)id);
    }

    public void setDefaultFormat(@Nonnull @NotEmpty String format) {
        this.defaultFormat = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)format), (String)"Default format cannot be null or empty");
    }

    @Nullable
    public List<String> apply(@Nullable ProfileRequestContext input) {
        ArrayList<String> fromConfig = new ArrayList<String>();
        List fromMetadata = super.apply(input);
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)input);
        if (relyingPartyCtx != null && relyingPartyCtx.getConfiguration() != null) {
            ProfileConfiguration profileConfig;
            if (this.profileId != null) {
                this.log.debug("Using overridden profile configuration ID: {}", (Object)this.profileId);
                profileConfig = relyingPartyCtx.getConfiguration().getProfileConfiguration(this.profileId);
            } else {
                profileConfig = relyingPartyCtx.getProfileConfig();
            }
            if (profileConfig != null && profileConfig instanceof AuthenticationProfileConfiguration) {
                fromConfig.addAll(((AuthenticationProfileConfiguration)profileConfig).getNameIDFormatPrecedence());
                this.log.debug("Configuration specifies the following formats: {}", fromConfig);
            } else {
                this.log.debug("No ProfileConfiguraton available (or not an AuthenticationProfileConfiguration)");
            }
        } else {
            this.log.debug("No RelyingPartyContext or RelyingPartyConfiguration available");
        }
        if (fromConfig.isEmpty()) {
            if (fromMetadata.isEmpty()) {
                this.log.debug("No formats specified in configuration or in metadata, returning default");
                return Collections.singletonList(this.defaultFormat);
            }
            this.log.debug("Configuration did not specify any formats, relying on metadata alone");
            return fromMetadata;
        }
        if (fromMetadata.isEmpty()) {
            this.log.debug("Metadata did not specify any formats, relying on configuration alone");
            return fromConfig;
        }
        fromConfig.retainAll(fromMetadata);
        this.log.debug("Filtered non-metadata-supported formats from configured formats, leaving: {}", fromConfig);
        return fromConfig;
    }
}

