/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.profile.config.AbstractSAMLProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ProfileConfiguration
extends AbstractSAMLProfileConfiguration
implements SAML2ProfileConfiguration {
    private boolean encryptionOptional = false;
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAssertionsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptNameIDsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAttributesPredicate = Predicates.alwaysFalse();
    private long proxyCount = 0L;
    @Nonnull
    @NonnullElements
    private Set<String> proxyAudiences = Collections.emptySet();

    public AbstractSAML2ProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    public long getProxyCount() {
        return this.proxyCount;
    }

    public void setProxyCount(@NonNegative long count) {
        this.proxyCount = Constraint.isGreaterThanOrEqual((long)0L, (long)count, (String)"Proxy count must be greater than or equal to 0");
    }

    @Override
    public Collection<String> getProxyAudiences() {
        return ImmutableList.copyOf(this.proxyAudiences);
    }

    public void setProxyAudiences(@Nonnull @NonnullElements Collection<String> audiences) {
        if (audiences == null || audiences.isEmpty()) {
            this.proxyAudiences = Collections.emptySet();
            return;
        }
        this.proxyAudiences = new HashSet<String>();
        for (String audience : audiences) {
            String trimmedAudience = StringSupport.trimOrNull((String)audience);
            if (trimmedAudience == null) continue;
            this.proxyAudiences.add(trimmedAudience);
        }
    }

    @Override
    public boolean isEncryptionOptional() {
        return this.encryptionOptional;
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptional = flag;
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getEncryptAssertions() {
        return this.encryptAssertionsPredicate;
    }

    public void setEncryptAssertions(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if assertions should be enecrypted cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getEncryptNameIDs() {
        return this.encryptNameIDsPredicate;
    }

    public void setEncryptNameIDs(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptNameIDsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if name identifiers should be encrypted cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getEncryptAttributes() {
        return this.encryptAttributesPredicate;
    }

    public void setEncryptAttributes(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAttributesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if attributes should be encrypted cannot be null");
    }
}

