/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.resource.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.resource.SVNBasicAuthenticationManager;
import net.shibboleth.ext.spring.resource.SVNResource;
import net.shibboleth.idp.profile.spring.resource.impl.ResourceNamespaceHandler;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.w3c.dom.Element;

public class SVNResourceParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resource", "SVNResource");
    public static final String REPOSITORY_URL_ATTRIB_NAME = "repositoryURL";
    public static final String CTX_TIMEOUT_ATTRIB_NAME = "connectionTimeout";
    public static final String READ_TIMEOUT_ATTRIB_NAME = "readTimeout";
    public static final String WORKING_COPY_DIR_ATTRIB_NAME = "workingCopyDirectory";
    public static final String REVISION_ATTRIB_NAME = "revision";
    public static final String RESOURCE_FILE_ATTRIB_NAME = "resourceFile";
    public static final String USERNAME_ATTRIB_NAME = "username";
    public static final String PASSWORD_ATTRIB_NAME = "password";
    public static final String PROXY_HOST_ATTRIB_NAME = "proxyHost";
    public static final String PROXY_PORT_ATTRIB_NAME = "proxyPort";
    public static final String PROXY_USERNAME_ATTRIB_NAME = "proxyUsername";
    public static final String PROXY_PASSWORD_ATTRIB_NAME = "proxyPassword";
    private final Logger log = LoggerFactory.getLogger(SVNResourceParser.class);

    protected Class<?> getBeanClass(Element element) {
        return SVNResource.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setLazyInit(true);
        builder.setDestroyMethodName("destroy");
        builder.setInitMethodName("initialize");
        super.doParse(element, parserContext, builder);
        ResourceNamespaceHandler.noFilters(element, parserContext.getReaderContext());
        BeanDefinition url = this.getRespositoryUrl(element, parserContext);
        builder.addConstructorArgValue((Object)this.buildClientManager(element, url, parserContext));
        builder.addConstructorArgValue((Object)url);
        builder.addConstructorArgValue((Object)this.getAttribute(element, WORKING_COPY_DIR_ATTRIB_NAME, parserContext));
        String revision = StringSupport.trimOrNull((String)this.getAttribute(element, REVISION_ATTRIB_NAME, parserContext));
        if (null == revision) {
            builder.addConstructorArgValue((Object)-1);
        } else {
            builder.addConstructorArgValue((Object)revision);
        }
        builder.addConstructorArgValue((Object)this.getAttribute(element, RESOURCE_FILE_ATTRIB_NAME, parserContext));
    }

    @Nonnull
    protected BeanDefinition buildClientManager(Element element, BeanDefinition url, ParserContext parserContext) {
        String readTimeout;
        String connectionTimeout;
        ManagedList authnMethods = new ManagedList();
        String username = this.getAttribute(element, USERNAME_ATTRIB_NAME, parserContext);
        if (username != null) {
            BeanDefinitionBuilder usernameBuilder = BeanDefinitionBuilder.genericBeanDefinition(SVNUserNameAuthentication.class);
            usernameBuilder.setLazyInit(true);
            usernameBuilder.addConstructorArgValue((Object)username);
            usernameBuilder.addConstructorArgValue((Object)false);
            usernameBuilder.addConstructorArgValue((Object)url);
            usernameBuilder.addConstructorArgValue((Object)false);
            authnMethods.add(usernameBuilder.getBeanDefinition());
            String password = this.getAttribute(element, PASSWORD_ATTRIB_NAME, parserContext);
            if (password != null) {
                BeanDefinitionBuilder passwordBuilder = BeanDefinitionBuilder.genericBeanDefinition(SVNPasswordAuthentication.class);
                passwordBuilder.setLazyInit(true);
                passwordBuilder.addConstructorArgValue((Object)username);
                passwordBuilder.addConstructorArgValue((Object)password);
                passwordBuilder.addConstructorArgValue((Object)false);
                passwordBuilder.addConstructorArgValue((Object)url);
                passwordBuilder.addConstructorArgValue((Object)false);
                authnMethods.add(passwordBuilder.getBeanDefinition());
            }
        }
        String proxyHost = this.getAttribute(element, PROXY_HOST_ATTRIB_NAME, parserContext);
        String proxyPort = this.getAttribute(element, PROXY_PORT_ATTRIB_NAME, parserContext);
        String proxyUser = this.getAttribute(element, PROXY_USERNAME_ATTRIB_NAME, parserContext);
        String proxyPassword = this.getAttribute(element, PROXY_PASSWORD_ATTRIB_NAME, parserContext, false);
        BeanDefinitionBuilder authnManager = BeanDefinitionBuilder.genericBeanDefinition(SVNBasicAuthenticationManager.class);
        authnManager.setLazyInit(true);
        authnManager.addConstructorArgValue((Object)authnMethods);
        if (proxyHost != null) {
            authnManager.addPropertyValue(PROXY_HOST_ATTRIB_NAME, (Object)proxyHost);
            authnManager.addPropertyValue(PROXY_PORT_ATTRIB_NAME, (Object)proxyPort);
            authnManager.addPropertyValue("proxyUserName", (Object)proxyUser);
            authnManager.addPropertyValue(PROXY_PASSWORD_ATTRIB_NAME, (Object)proxyPassword);
        }
        if (null != (connectionTimeout = this.getAttribute(element, CTX_TIMEOUT_ATTRIB_NAME, parserContext))) {
            this.log.warn("SVN resource definition attribute '{}' is ignored.", (Object)CTX_TIMEOUT_ATTRIB_NAME);
        }
        if (null != (readTimeout = this.getAttribute(element, READ_TIMEOUT_ATTRIB_NAME, parserContext))) {
            this.log.warn("SVN resource definition attribute '{}' is ignored.", (Object)READ_TIMEOUT_ATTRIB_NAME);
        }
        BeanDefinitionBuilder clientManager = BeanDefinitionBuilder.genericBeanDefinition(SVNClientManager.class);
        clientManager.setLazyInit(true);
        clientManager.setFactoryMethod("newInstance");
        clientManager.addPropertyValue("authenticationManager", (Object)authnManager.getBeanDefinition());
        return clientManager.getBeanDefinition();
    }

    protected BeanDefinition getRespositoryUrl(Element element, ParserContext parserContext) {
        String value = this.getAttribute(element, REPOSITORY_URL_ATTRIB_NAME, parserContext);
        if (null == value) {
            this.error("SVN resource definition.  No repositoryURL specified", parserContext);
        }
        BeanDefinitionBuilder urlBuilder = BeanDefinitionBuilder.genericBeanDefinition(SVNURL.class);
        urlBuilder.setLazyInit(true);
        urlBuilder.setFactoryMethod("parseURIDecoded");
        urlBuilder.addConstructorArgValue((Object)value);
        return urlBuilder.getBeanDefinition();
    }

    @Nullable
    protected String getAttribute(Element element, String attributeName, ParserContext parserContext, boolean trim) {
        if (element.hasAttributeNS(null, attributeName)) {
            String value = element.getAttributeNS(null, attributeName);
            if (trim) {
                value = StringSupport.trimOrNull((String)value);
            }
            if (value == null) {
                this.error("SVN resource definition attribute '" + attributeName + "' may not be an empty string", parserContext);
            }
            return value;
        }
        return null;
    }

    @Nullable
    protected String getAttribute(Element element, String attributeName, ParserContext parserContext) {
        return this.getAttribute(element, attributeName, parserContext, true);
    }

    protected void error(String message, ParserContext parserContext) {
        this.log.error(message);
        throw new BeanDefinitionParsingException(new Problem(message, new Location(parserContext.getReaderContext().getResource())));
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

