/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.saml.metadata.RelyingPartyMetadataProvider;
import net.shibboleth.idp.saml.metadata.impl.AttributeMappingNodeProcessor;
import net.shibboleth.idp.saml.security.impl.KeyAuthorityNodeProcessor;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.EntitiesDescriptorNameProcessor;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class NodeProcessingAttachingBeanPostProcessor
implements BeanPostProcessor {
    @Nullable
    private final ReloadableService<AttributeResolver> atributeResolverService;

    public NodeProcessingAttachingBeanPostProcessor(@Nullable @ParameterName(name="service") ReloadableService<AttributeResolver> service) {
        this.atributeResolverService = service;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (!(bean instanceof MetadataResolver) || bean instanceof ChainingMetadataResolver || bean instanceof RelyingPartyMetadataProvider) {
            return bean;
        }
        MetadataResolver resolver = (MetadataResolver)bean;
        boolean filterAttached = false;
        MetadataFilter filter = resolver.getMetadataFilter();
        if (filter != null) {
            if (filter instanceof NodeProcessingMetadataFilter) {
                filterAttached = true;
            } else if (filter instanceof MetadataFilterChain) {
                for (MetadataFilter f : ((MetadataFilterChain)filter).getFilters()) {
                    if (!(f instanceof NodeProcessingMetadataFilter)) continue;
                    filterAttached = true;
                    break;
                }
            }
        }
        if (!filterAttached) {
            NodeProcessingMetadataFilter filterToAttach = new NodeProcessingMetadataFilter();
            ArrayList<MetadataNodeProcessor> processors = new ArrayList<MetadataNodeProcessor>(Arrays.asList(new EntitiesDescriptorNameProcessor(), new KeyAuthorityNodeProcessor()));
            if (null != this.atributeResolverService) {
                processors.add((MetadataNodeProcessor)new AttributeMappingNodeProcessor(this.atributeResolverService));
            }
            filterToAttach.setNodeProcessors(processors);
            try {
                filterToAttach.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BeanCreationException("Error initializing NodeProcessingMetadataFilter", (Throwable)e);
            }
            if (filter == null) {
                resolver.setMetadataFilter((MetadataFilter)filterToAttach);
            } else if (filter instanceof MetadataFilterChain) {
                ((MetadataFilterChain)filter).getFilters().add(filterToAttach);
            } else {
                MetadataFilterChain chain = new MetadataFilterChain();
                chain.setFilters(Arrays.asList(filter, filterToAttach));
                resolver.setMetadataFilter((MetadataFilter)chain);
            }
        }
        return resolver;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

