/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.idp.profile.spring.factory.AbstractBasicCredentialFactoryBean;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;

public class BasicResourceCredentialFactoryBean
extends AbstractBasicCredentialFactoryBean {
    private final Logger log = LoggerFactory.getLogger(BasicResourceCredentialFactoryBean.class);
    @Nullable
    private Resource publicKeyInfo;
    @Nullable
    private Resource privateKeyInfo;
    @Nullable
    private Resource secretKeyInfo;

    @Nullable
    public Resource getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public void setPublicKeyInfo(@Nullable Resource info) {
        this.publicKeyInfo = info;
    }

    @Nullable
    public Resource getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    public void setPrivateKeyInfo(@Nullable Resource info) {
        this.privateKeyInfo = info;
    }

    @Nullable
    public Resource getSecretKeyInfo() {
        return this.secretKeyInfo;
    }

    public void setSecretKeyInfo(@Nullable Resource info) {
        this.secretKeyInfo = info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected PublicKey getPublicKey() {
        if (null == this.getPublicKeyInfo()) {
            return null;
        }
        try (InputStream is = this.getPublicKeyInfo().getInputStream();){
            PublicKey publicKey = KeyPairUtil.readPublicKey((InputStream)is);
            return publicKey;
        }
        catch (IOException e) {
            this.log.error("{}: Could not decode public key", (Object)this.getConfigDescription(), (Object)e);
            throw new FatalBeanException("Could not decode public key", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected PrivateKey getPrivateKey() {
        if (null == this.getPrivateKeyInfo()) {
            return null;
        }
        try (InputStream is = this.getPrivateKeyInfo().getInputStream();){
            PrivateKey privateKey = KeySupport.decodePrivateKey((InputStream)is, (char[])this.getPrivateKeyPassword());
            return privateKey;
        }
        catch (IOException | KeyException e) {
            this.log.error("{}: Could not decode private key", (Object)this.getConfigDescription(), (Object)e);
            throw new BeanCreationException("Could not decode private key", this.getConfigDescription(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected SecretKey getSecretKey() {
        if (null == this.getSecretKeyInfo()) {
            return null;
        }
        try (InputStream is = this.getSecretKeyInfo().getInputStream();){
            SecretKey secretKey = KeySupport.decodeSecretKey((byte[])this.decodeSecretKey(ByteStreams.toByteArray((InputStream)is)), (String)this.getSecretKeyAlgorithm());
            return secretKey;
        }
        catch (IOException | KeyException e) {
            this.log.error("{}: Could not decode secret key", (Object)this.getConfigDescription(), (Object)e);
            throw new BeanCreationException("Could not decode secret key", (Throwable)e);
        }
    }
}

