/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty.impl;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.relyingparty.CriteriaRelyingPartyConfigurationResolver;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Resolver;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaSelfEntityIDResolver
extends AbstractIdentifiedInitializableComponent
implements Resolver<String, CriteriaSet>,
IdentifiableComponent {
    private Logger log = LoggerFactory.getLogger(CriteriaSelfEntityIDResolver.class);
    @NonnullAfterInit
    private CriteriaRelyingPartyConfigurationResolver rpcResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable CriteriaRelyingPartyConfigurationResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rpcResolver = resolver;
    }

    public void setId(@Nonnull String componentId) {
        super.setId(componentId);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpcResolver == null) {
            throw new ComponentInitializationException("CriteriaRelyingPartyConfigurationResolver was null");
        }
    }

    protected void doDestroy() {
        this.rpcResolver = null;
        super.doDestroy();
    }

    @Nonnull
    @NonnullElements
    public Iterable<String> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        String entityID = this.resolveSingle(criteria);
        if (entityID != null) {
            return Collections.singletonList(entityID);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        RelyingPartyConfiguration rpc = (RelyingPartyConfiguration)this.rpcResolver.resolveSingle((Object)criteria);
        if (rpc != null) {
            return rpc.getResponderId();
        }
        return null;
    }
}

