/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import com.google.common.base.Function;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.webflow.execution.RequestContext;

public class ReloadServiceConfiguration
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String SERVICE_ID = "serviceId";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ReloadServiceConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, ReloadableService> serviceLookupStrategy = new WebFlowApplicationContextLookupStrategy();
    @Nullable
    private ReloadableService service;

    public void setServiceLookupStrategy(@Nonnull Function<ProfileRequestContext, ReloadableService> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.serviceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ReloadableService lookup strategy cannot be null");
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletResponse() == null) {
            this.log.debug("{} No HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.service = (ReloadableService)this.serviceLookupStrategy.apply((Object)profileRequestContext);
        if (this.service == null) {
            this.log.warn("{} Unable to locate service to reload", (Object)this.getLogPrefix());
            try {
                this.getHttpServletResponse().sendError(404, "Service not found.");
            }
            catch (IOException e) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
            return false;
        }
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        String id = this.service instanceof IdentifiedComponent ? ((IdentifiedComponent)this.service).getId() : "(unnamed)";
        this.log.debug("{} Reloading configuration for '{}'", (Object)this.getLogPrefix(), (Object)id);
        try {
            this.service.reload();
            this.log.debug("{} Reloaded configuration for '{}'", (Object)this.getLogPrefix(), (Object)id);
            this.getHttpServletResponse().setStatus(200);
            this.getHttpServletResponse().getWriter().println("Configuration reloaded for '" + id + "'");
        }
        catch (ServiceException e) {
            this.log.error("{} Error reloading service configuration for '{}'", new Object[]{this.getLogPrefix(), id, e});
            try {
                this.getHttpServletResponse().sendError(500, e.getMessage());
            }
            catch (IOException e2) {
                this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e2);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private class WebFlowApplicationContextLookupStrategy
    implements Function<ProfileRequestContext, ReloadableService> {
        private WebFlowApplicationContextLookupStrategy() {
        }

        @Nullable
        public ReloadableService apply(@Nullable ProfileRequestContext input) {
            SpringRequestContext springRequestContext = (SpringRequestContext)input.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                ReloadServiceConfiguration.this.log.warn("{} Spring request context not found in profile request context", (Object)ReloadServiceConfiguration.this.getLogPrefix());
                return null;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                ReloadServiceConfiguration.this.log.warn("{} Web Flow request context not found in Spring request context", (Object)ReloadServiceConfiguration.this.getLogPrefix());
                return null;
            }
            String id = (String)requestContext.getFlowScope().get(ReloadServiceConfiguration.SERVICE_ID);
            if (id == null) {
                ReloadServiceConfiguration.this.log.warn("{} No {} flow variable found in request", (Object)ReloadServiceConfiguration.this.getLogPrefix(), (Object)ReloadServiceConfiguration.SERVICE_ID);
                return null;
            }
            try {
                Object bean = requestContext.getActiveFlow().getApplicationContext().getBean(id);
                if (bean != null && bean instanceof ReloadableService) {
                    return (ReloadableService)bean;
                }
            }
            catch (BeansException beansException) {
                // empty catch block
            }
            ReloadServiceConfiguration.this.log.warn("{} No bean of the correct type found named {}", (Object)ReloadServiceConfiguration.this.getLogPrefix(), (Object)id);
            return null;
        }
    }
}

