/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class ProfileActionBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProfileActionBeanFactoryPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String beanName : beanFactory.getBeanNamesForAnnotation(Prototype.class)) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (beanDefinition.isPrototype()) continue;
            this.log.warn("Profile action '{}' is not '{}' scope but must be, please check your configuration.", (Object)beanName, (Object)"prototype");
            beanDefinition.setScope("prototype");
        }
    }
}

