/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.audit.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.AuditContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WriteAuditLog
extends AbstractProfileAction {
    private static DateTimeFormatter v2Formatter = ISODateTimeFormat.basicDateTimeNoMillis();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(WriteAuditLog.class);
    @Nonnull
    private Function<ProfileRequestContext, AuditContext> auditContextLookupStrategy = new ChildContextLookup(AuditContext.class);
    @Nonnull
    @NotEmpty
    private Map<String, List<String>> formattingMap = Collections.emptyMap();
    @Nullable
    private String dateTimeFormat;
    private boolean useDefaultTimeZone;
    @Nullable
    private RequestContext requestContext;
    @Nullable
    private AuditContext auditCtx;
    @Nullable
    private HttpServletRequest httpRequest;

    public void setAuditContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AuditContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.auditContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuditContext lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<String, List<String>> getFormattingMap() {
        return ImmutableMap.copyOf(this.formattingMap);
    }

    public void setFormattingMap(@Nonnull @NonnullElements Map<String, String> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"Audit formatting map cannot be null");
        this.formattingMap = new HashMap<String, List<String>>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String category = StringSupport.trimOrNull((String)entry.getKey());
            String s = StringSupport.trimOrNull((String)entry.getValue());
            if (category == null || s == null) continue;
            int len = s.length();
            boolean inToken = false;
            ArrayList<String> format = new ArrayList<String>();
            StringBuilder field = new StringBuilder();
            for (int pos = 0; pos < len; ++pos) {
                char ch = s.charAt(pos);
                if (inToken) {
                    if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '%') {
                        format.add(field.toString());
                        field.setLength(0);
                        inToken = false;
                    }
                } else if (ch == '%') {
                    if (field.length() > 0) {
                        format.add(field.toString());
                        field.setLength(0);
                    }
                    inToken = true;
                }
                field.append(ch);
            }
            if (field.length() > 0) {
                format.add(field.toString());
            }
            this.formattingMap.put(category, format);
        }
    }

    public void setDateTimeFormat(@Nullable @NotEmpty String format) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dateTimeFormat = StringSupport.trimOrNull((String)format);
    }

    public void setUseDefaultTimeZone(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.useDefaultTimeZone = flag;
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        this.requestContext = springRequestContext;
        return super.doExecute(springRequestContext, profileRequestContext);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.formattingMap.isEmpty()) {
            this.log.debug("No formatting for audit records supplied, nothing to do");
            return false;
        }
        this.auditCtx = (AuditContext)this.auditContextLookupStrategy.apply((Object)profileRequestContext);
        this.httpRequest = this.getHttpServletRequest();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        for (Map.Entry<String, List<String>> entry : this.formattingMap.entrySet()) {
            StringBuilder record = new StringBuilder();
            for (String token : entry.getValue()) {
                if (token.startsWith("%")) {
                    if (token.length() == 1 || token.charAt(1) == '%') {
                        record.append('%');
                        continue;
                    }
                    String field = token.substring(1);
                    if ("T".equals(field)) {
                        if (this.dateTimeFormat != null) {
                            record.append(new DateTime(this.useDefaultTimeZone ? DateTimeZone.getDefault() : DateTimeZone.UTC).toString(this.dateTimeFormat));
                            continue;
                        }
                        record.append(new DateTime().toString(v2Formatter.withZone(this.useDefaultTimeZone ? DateTimeZone.getDefault() : DateTimeZone.UTC)));
                        continue;
                    }
                    if ("e".equals(field)) {
                        Event event = this.requestContext.getCurrentEvent();
                        if (event == null || event.getId().equals("proceed")) continue;
                        record.append(event.getId());
                        continue;
                    }
                    if ("P".equals(field)) {
                        record.append(profileRequestContext.getProfileId());
                        continue;
                    }
                    if ("a".equals(field) && this.httpRequest != null) {
                        record.append(this.httpRequest.getRemoteAddr());
                        continue;
                    }
                    if ("URI".equals(field) && this.httpRequest != null) {
                        record.append(this.httpRequest.getRequestURI());
                        continue;
                    }
                    if ("URL".equals(field) && this.httpRequest != null) {
                        record.append(this.httpRequest.getRequestURL());
                        continue;
                    }
                    if ("UA".equals(field) && this.httpRequest != null) {
                        record.append(this.httpRequest.getHeader("User-Agent"));
                        continue;
                    }
                    if (this.auditCtx == null) continue;
                    Iterator iter = this.auditCtx.getFieldValues(field).iterator();
                    while (iter.hasNext()) {
                        record.append((String)iter.next());
                        if (!iter.hasNext()) continue;
                        record.append(',');
                    }
                    continue;
                }
                record.append(token);
            }
            this.filter(record);
            LoggerFactory.getLogger((String)(entry.getKey() + '.' + profileRequestContext.getLoggingId())).info(record.toString());
        }
    }

    protected void filter(@Nonnull StringBuilder entry) {
    }
}

