/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorAction;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateProfileInterceptorContext
extends AbstractProfileInterceptorAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateProfileInterceptorContext.class);
    @Nonnull
    @NonnullElements
    private Collection<ProfileInterceptorFlowDescriptor> availableFlows = Collections.emptyList();
    @NonnullAfterInit
    private Function<ProfileRequestContext, Collection<String>> activeFlowsLookupStrategy;

    public void setAvailableFlows(@Nonnull @NonnullElements Collection<ProfileInterceptorFlowDescriptor> flows) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(flows, (String)"Flow collection cannot be null");
        this.availableFlows = new ArrayList<ProfileInterceptorFlowDescriptor>(Collections2.filter(flows, (Predicate)Predicates.notNull()));
    }

    public void setActiveFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activeFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Flow lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.activeFlowsLookupStrategy == null) {
            throw new ComponentInitializationException("Flow lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        interceptorContext.getAvailableFlows().clear();
        interceptorContext.setAttemptedFlow(null);
        Collection activeFlows = (Collection)this.activeFlowsLookupStrategy.apply((Object)profileRequestContext);
        if (activeFlows != null) {
            for (String id : activeFlows) {
                final String flowId = "intercept/" + id;
                Optional flow = Iterables.tryFind(this.availableFlows, (Predicate)new Predicate<ProfileInterceptorFlowDescriptor>(){

                    public boolean apply(ProfileInterceptorFlowDescriptor input) {
                        return input.getId().equals(flowId);
                    }
                });
                if (flow.isPresent()) {
                    this.log.debug("{} Installing flow {} into interceptor context", (Object)this.getLogPrefix(), (Object)flowId);
                    interceptorContext.getAvailableFlows().put(((ProfileInterceptorFlowDescriptor)flow.get()).getId(), flow.get());
                    continue;
                }
                this.log.error("{} Configured interceptor flow {} not available for use", (Object)this.getLogPrefix(), (Object)flowId);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
        }
    }
}

