/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public final class InitializeProfileRequestContext
extends AbstractProfileAction {
    @Nullable
    private String profileId;
    @Nullable
    private String loggingId;
    private boolean browserProfile;

    public void setProfileId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileId = StringSupport.trimOrNull((String)id);
    }

    public void setLoggingId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loggingId = StringSupport.trimOrNull((String)id);
    }

    public void setBrowserProfile(boolean browser) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.browserProfile = browser;
    }

    @Nonnull
    public Event execute(@Nonnull RequestContext springRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ProfileRequestContext prc = new ProfileRequestContext();
        if (this.profileId != null) {
            prc.setProfileId(this.profileId);
        }
        if (this.loggingId != null) {
            prc.setLoggingId(this.loggingId);
        }
        prc.setBrowserProfile(this.browserProfile);
        springRequestContext.getConversationScope().put("opensamlProfileRequestContext", (Object)prc);
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }
}

