/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ScriptedPredicate
extends net.shibboleth.utilities.java.support.logic.ScriptedPredicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedPredicate.class);

    public ScriptedPredicate(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript, @Nullable @ParameterName(name="extraInfo") @NotEmpty String extraInfo) {
        super(theScript, extraInfo);
    }

    public ScriptedPredicate(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript) {
        super(theScript);
    }

    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        super.prepareContext(scriptContext, input);
        scriptContext.setAttribute("profileContext", input[0], 100);
    }

    static ScriptedPredicate resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedPredicate scriptedPredicate = new ScriptedPredicate(script, resource.getDescription());
            return scriptedPredicate;
        }
    }

    static ScriptedPredicate resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedPredicate.resourceScript("JavaScript", resource);
    }

    static ScriptedPredicate inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedPredicate(script, "Inline");
    }

    static ScriptedPredicate inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript("JavaScript", scriptSource);
        return new ScriptedPredicate(script, "Inline");
    }
}

