/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.profile.logic.AbstractAttributePredicate;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.ReadableDuration;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DateAttributePredicate.class);
    @Nonnull
    @NotEmpty
    private final String attributeName;
    @Nonnull
    private final DateTimeFormatter dateTimeFormatter;
    @Nullable
    private org.joda.time.Duration systemTimeOffset;
    private boolean resultIfMissing;

    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute) {
        this(attribute, ISODateTimeFormat.dateOptionalTimeParser());
    }

    @Deprecated
    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute, @Nonnull @ParameterName(name="formatter") DateTimeFormatter formatter) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = (DateTimeFormatter)Constraint.isNotNull((Object)formatter, (String)"Formatter cannot be null");
        this.resultIfMissing = false;
    }

    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute, @Nonnull @ParameterName(name="formatString") @NotEmpty String formatString) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = DateTimeFormat.forPattern((String)((String)Constraint.isNotNull((Object)formatString, (String)"Format string cannot be null")));
        this.resultIfMissing = false;
    }

    @Deprecated
    public void setSystemTimeOffset(@Nonnull org.joda.time.Duration offset) {
        this.systemTimeOffset = (org.joda.time.Duration)Constraint.isNotNull((Object)offset, (String)"Offset cannot be null");
    }

    @Duration
    public void setOffset(@Duration long offset) {
        this.systemTimeOffset = org.joda.time.Duration.millis((long)offset);
    }

    public void setResultIfMissing(boolean flag) {
        this.resultIfMissing = flag;
    }

    @Override
    protected boolean allowNullAttributeContext() {
        return this.resultIfMissing;
    }

    @Override
    protected boolean hasMatch(@Nonnull @NonnullElements Map<String, IdPAttribute> attributeMap) {
        IdPAttribute attribute = attributeMap.get(this.attributeName);
        if (attribute == null) {
            this.log.debug("Attribute {} not found in context, returning {}", (Object)this.attributeName, (Object)this.resultIfMissing);
            return this.resultIfMissing;
        }
        if (attribute.getValues().isEmpty()) {
            this.log.debug("Attribute {} has no values, returning {}", (Object)this.attributeName, (Object)this.resultIfMissing);
            return this.resultIfMissing;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue)) continue;
            String dateString = ((StringAttributeValue)value).getValue();
            try {
                if (!this.dateTimeFormatter.parseDateTime(dateString).plus((ReadableDuration)this.systemTimeOffset).isAfterNow()) continue;
                return true;
            }
            catch (RuntimeException e) {
                this.log.info("{} is not a valid date for the configured date parser", (Object)dateString);
            }
        }
        return false;
    }
}

