/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.util.ArrayList;
import java.util.Collections;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.DateAttributePredicate;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateAttributePredicateTest {
    private final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();

    @DataProvider(name="test-data")
    public Object[][] provideTestData() {
        return new Object[][]{{new DateAttributePredicate("expirationDate"), "expirationDate", this.dateStrings(Duration.standardDays((long)1L)), true}, {new DateAttributePredicate("expirationDate"), "expirationDate", this.dateStrings(Duration.ZERO), false}, {new DateAttributePredicate("expirationDate"), "expirationDate", this.dateStrings(Duration.standardDays((long)-1L)), false}, {this.newPredicate("expirationDate", Duration.standardDays((long)90L)), "expirationDate", this.dateStrings(Duration.standardDays((long)91L)), true}, {this.newPredicate("expirationDate", Duration.standardDays((long)-30L)), "expirationDate", this.dateStrings(Duration.standardDays((long)29L)), false}};
    }

    @Test(dataProvider="test-data")
    public void testApply(DateAttributePredicate predicate, String attribute, String[] values, boolean expected) throws Exception {
        Assert.assertEquals((boolean)predicate.apply(this.createProfileRequestContext(attribute, values)), (boolean)expected);
    }

    private ProfileRequestContext createProfileRequestContext(String name, String[] values) {
        ProfileRequestContext prc = new ProfileRequestContext();
        RelyingPartyContext rpc = new RelyingPartyContext();
        IdPAttribute attribute = new IdPAttribute(name);
        ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
        for (String value : values) {
            attributeValues.add(new StringAttributeValue(value));
        }
        attribute.setValues(attributeValues);
        AttributeContext ac = new AttributeContext();
        ac.setIdPAttributes(Collections.singletonList(attribute));
        ac.setUnfilteredIdPAttributes(Collections.singletonList(attribute));
        rpc.addSubcontext((BaseContext)ac);
        prc.addSubcontext((BaseContext)rpc);
        return prc;
    }

    private String[] dateStrings(Duration ... offsets) {
        String[] dates = new String[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            dates[i] = this.formatter.print((ReadableInstant)DateTime.now().plus((ReadableDuration)offsets[i]));
        }
        return dates;
    }

    private DateAttributePredicate newPredicate(String attribute, Duration offset) {
        DateAttributePredicate p = new DateAttributePredicate(attribute);
        p.setSystemTimeOffset(offset);
        return p;
    }
}

