/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import com.google.common.base.Predicates;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProfileInterceptorFlowDescriptorTest {
    private ProfileInterceptorFlowDescriptor descriptor;
    private RequestContext src;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() throws Exception {
        this.descriptor = new ProfileInterceptorFlowDescriptor();
        this.descriptor.setId("test");
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
    }

    @Test
    public void testInstantation() throws Exception {
        Assert.assertEquals((String)this.descriptor.getId(), (String)"test");
        Assert.assertTrue((boolean)this.descriptor.isNonBrowserSupported());
        Assert.assertNull((Object)this.descriptor.getStorageService());
        Assert.assertTrue((boolean)this.descriptor.apply(this.prc));
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableActivationCondition() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setActivationCondition(Predicates.alwaysFalse());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageService() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setStorageService(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableNonBrowserSupport() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setNonBrowserSupported(true);
    }

    @Test
    public void testEquality() {
        ProfileInterceptorFlowDescriptor descriptorWithSameId = new ProfileInterceptorFlowDescriptor();
        descriptorWithSameId.setId("test");
        Assert.assertTrue((boolean)this.descriptor.equals((Object)descriptorWithSameId));
        ProfileInterceptorFlowDescriptor descriptorWithDifferentId = new ProfileInterceptorFlowDescriptor();
        descriptorWithDifferentId.setId("differentId");
        Assert.assertFalse((boolean)this.descriptor.equals((Object)descriptorWithDifferentId));
    }

    @Test
    public void testMutatingPredicate() throws Exception {
        this.descriptor.setActivationCondition(Predicates.alwaysFalse());
        this.descriptor.initialize();
        Assert.assertFalse((boolean)this.descriptor.apply(this.prc));
    }

    @Test
    public void testMutatingNonBrowserSupport() {
        this.descriptor.setNonBrowserSupported(true);
        Assert.assertTrue((boolean)this.descriptor.isNonBrowserSupported());
        this.descriptor.setNonBrowserSupported(false);
        Assert.assertFalse((boolean)this.descriptor.isNonBrowserSupported());
    }
}

