/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.logic.AbstractAttributePredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DynamicAttributePredicate.class);
    @Nonnull
    @NonnullElements
    private ListMultimap<String, Function<ProfileRequestContext, String>> attributeFunctionMap = ArrayListMultimap.create();

    public void setAttributeFunctionMap(@Nonnull @NonnullElements Map<String, Collection<Function<ProfileRequestContext, String>>> map) {
        Constraint.isNotNull(map, (String)"Attribute/value map cannot be null");
        this.attributeFunctionMap.clear();
        for (Map.Entry<String, Collection<Function<ProfileRequestContext, String>>> entry : map.entrySet()) {
            String attributeId = StringSupport.trimOrNull((String)entry.getKey());
            this.attributeFunctionMap.putAll((Object)attributeId, (Iterable)Collections2.filter(entry.getValue(), (Predicate)Predicates.notNull()));
        }
    }

    @Override
    public boolean apply(@Nullable ProfileRequestContext input) {
        Map attributes;
        AttributeContext attributeCtx = (AttributeContext)this.getAttributeContextLookupStrategy().apply((Object)input);
        if (attributeCtx == null) {
            this.log.warn("No AttributeContext located for evaluation");
            return this.allowNullAttributeContext();
        }
        Map map = attributes = this.isUseUnfilteredAttributes() ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes();
        if (this.hasMatch(input, attributes)) {
            this.log.debug("Context satisfied requirements");
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasMatch(@Nonnull @NonnullElements Map<String, IdPAttribute> attributeMap) {
        this.log.error("Method should never be called");
        return false;
    }

    protected boolean hasMatch(@Nullable ProfileRequestContext profileRequestContext, @Nonnull @NonnullElements Map<String, IdPAttribute> attributeMap) {
        for (String id : this.attributeFunctionMap.keySet()) {
            this.log.debug("Checking for attribute: {}", (Object)id);
            IdPAttribute attribute = attributeMap.get(id);
            if (attribute == null) {
                this.log.debug("Attribute {} not found in context", (Object)id);
                return false;
            }
            boolean matched = false;
            for (Function fn : this.attributeFunctionMap.get((Object)id)) {
                if (!this.findMatch((String)fn.apply((Object)profileRequestContext), attribute)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            this.log.debug("Attribute {} values not matched", (Object)id);
            return false;
        }
        return true;
    }

    protected boolean findMatch(@Nonnull @NotEmpty String toMatch, @Nonnull IdPAttribute attribute) {
        if ("*".equals(toMatch)) {
            this.log.debug("Wildcard (*) value rule for attribute {}", (Object)attribute.getId());
            return true;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue) || !toMatch.equals(value.getValue())) continue;
            this.log.debug("Found matching value ({}) in attribute {}", (Object)toMatch, (Object)attribute.getId());
            return true;
        }
        return false;
    }
}

