/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelyingPartyConfiguration
extends AbstractIdentifiableInitializableComponent
implements IdentifiedComponent,
Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RelyingPartyConfiguration.class);
    @Nullable
    private ServletRequest servletRequest;
    @Nullable
    private Function<ProfileRequestContext, String> responderIdLookupStrategy;
    @Nullable
    @NotEmpty
    private String responderId;
    @Nonnull
    private Predicate<ProfileRequestContext> detailedErrorsPredicate;
    @Nullable
    private Function<ProfileRequestContext, Map<String, ProfileConfiguration>> profileConfigurationsLookupStrategy;
    @Nonnull
    @NonnullElements
    private Map<String, ProfileConfiguration> profileConfigurations;
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();

    public RelyingPartyConfiguration() {
        this.detailedErrorsPredicate = Predicates.alwaysFalse();
        this.profileConfigurations = Collections.emptyMap();
    }

    public void setServletRequest(@Nullable ServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.servletRequest = request;
    }

    @Nonnull
    @NotEmpty
    public String getResponderId() {
        return (String)Constraint.isNotNull((Object)this.getIndirectProperty(this.responderIdLookupStrategy, this.responderId), (String)"ResponderId cannot be null");
    }

    public void setResponderId(@Nullable String responder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderId = StringSupport.trimOrNull((String)responder);
    }

    public void setResponderIdLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderIdLookupStrategy = strategy;
    }

    public boolean isDetailedErrors() {
        return this.detailedErrorsPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setDetailedErrors(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.detailedErrorsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getDetailedErrorsPredicate() {
        return this.detailedErrorsPredicate;
    }

    public void setDetailedErrorsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.detailedErrorsPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Detailed errors predicate cannot be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, ProfileConfiguration> getProfileConfigurations() {
        return ImmutableMap.copyOf(this.getIndirectProperty(this.profileConfigurationsLookupStrategy, this.profileConfigurations));
    }

    @Nullable
    public ProfileConfiguration getProfileConfiguration(@Nullable String profileId) {
        String trimmedId = StringSupport.trimOrNull((String)profileId);
        if (trimmedId == null) {
            return null;
        }
        return this.getProfileConfigurations().get(trimmedId);
    }

    public void setProfileConfigurations(@Nullable @NonnullElements Collection<ProfileConfiguration> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (configs == null) {
            this.profileConfigurations = Collections.emptyMap();
        } else {
            this.profileConfigurations = new HashMap<String, ProfileConfiguration>();
            for (ProfileConfiguration config : Collections2.filter(configs, (Predicate)Predicates.notNull())) {
                String trimmedId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)config.getId()), (String)("ID of profile configuration class " + config.getClass().getName() + " cannot be null"));
                this.profileConfigurations.put(trimmedId, config);
            }
        }
    }

    public void setProfileConfigurationsLookupStrategy(@Nullable Function<ProfileRequestContext, Map<String, ProfileConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileConfigurationsLookupStrategy = strategy;
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Relying partying configuration activation condition cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.responderId == null && this.responderIdLookupStrategy == null) {
            throw new ComponentInitializationException("Responder ID and lookup strategy cannot both be null");
        }
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.activationCondition.apply((Object)input);
    }

    @Nullable
    protected ProfileRequestContext getProfileRequestContext() {
        if (this.servletRequest != null) {
            Object object = this.servletRequest.getAttribute("opensamlProfileRequestContext");
            if (object instanceof ProfileRequestContext) {
                return (ProfileRequestContext)object;
            }
            this.log.warn("RelyingPartyConfiguration {}: No ProfileRequestContext in request", (Object)this.getId());
        } else {
            this.log.warn("RelyingPartyConfiguration {}: ServletRequest was null", (Object)this.getId());
        }
        return null;
    }

    @Nullable
    protected <T> T getIndirectProperty(@Nullable Function<ProfileRequestContext, T> lookupStrategy, @Nullable T staticValue) {
        Object prop;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (lookupStrategy != null && (prop = lookupStrategy.apply((Object)this.getProfileRequestContext())) != null) {
            return (T)prop;
        }
        return staticValue;
    }
}

