/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public abstract class AbstractProfileConfiguration
implements ProfileConfiguration {
    @Nonnull
    @NotEmpty
    private final String profileId;
    @Nonnull
    @NonnullElements
    private List<String> inboundFlows;
    @Nonnull
    @NonnullElements
    private List<String> outboundFlows;
    @Nullable
    private SecurityConfiguration securityConfiguration;

    public AbstractProfileConfiguration(@Nonnull @NotEmpty String id) {
        this.profileId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Profile identifier cannot be null or empty");
        this.outboundFlows = Collections.emptyList();
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.profileId;
    }

    @Override
    @Nullable
    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(@Nullable SecurityConfiguration configuration) {
        this.securityConfiguration = configuration;
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getInboundInterceptorFlows() {
        return this.inboundFlows;
    }

    public void setInboundInterceptorFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.inboundFlows = new ArrayList<String>(StringSupport.normalizeStringCollection(flows));
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getOutboundInterceptorFlows() {
        return this.outboundFlows;
    }

    public void setOutboundInterceptorFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.outboundFlows = new ArrayList<String>(StringSupport.normalizeStringCollection(flows));
    }

    public int hashCode() {
        return this.profileId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProfileConfiguration)) {
            return false;
        }
        AbstractProfileConfiguration other = (AbstractProfileConfiguration)obj;
        return Objects.equals(this.profileId, other.getId());
    }
}

