/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import com.google.common.base.Function;
import java.util.Objects;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.PreviousEventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;

public class WebFlowCurrentEventLookupFunction
implements Function<ProfileRequestContext, EventContext> {
    @Nullable
    public EventContext apply(@Nullable ProfileRequestContext input) {
        SpringRequestContext springContext;
        if (input == null) {
            return null;
        }
        EventContext eventCtx = (EventContext)input.getSubcontext(EventContext.class);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            eventCtx = (EventContext)input.getSubcontext(PreviousEventContext.class);
        }
        if ((springContext = (SpringRequestContext)input.getSubcontext(SpringRequestContext.class)) == null || springContext.getRequestContext() == null || springContext.getRequestContext().getCurrentEvent() == null) {
            return eventCtx;
        }
        RequestContext springRequest = springContext.getRequestContext();
        if (eventCtx == null || eventCtx.getEvent() == null || !Objects.equals(eventCtx.getEvent().toString(), springRequest.getCurrentEvent().getId())) {
            eventCtx = (EventContext)input.getSubcontext(EventContext.class, true);
            eventCtx.setEvent((Object)springRequest.getCurrentEvent());
        }
        return eventCtx;
    }
}

