/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;

public class SignatureSigningConfigurationLookupFunction
extends AbstractRelyingPartyLookupFunction<List<SignatureSigningConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    @Nullable
    public List<SignatureSigningConfiguration> apply(@Nullable ProfileRequestContext input) {
        SecurityConfiguration defaultConfig;
        ProfileConfiguration pc;
        ArrayList<SignatureSigningConfiguration> configs = new ArrayList<SignatureSigningConfiguration>();
        RelyingPartyContext rpc = (RelyingPartyContext)((Object)this.getRelyingPartyContextLookupStrategy().apply((Object)input));
        if (rpc != null && (pc = rpc.getProfileConfig()) != null && pc.getSecurityConfiguration() != null) {
            configs.add(pc.getSecurityConfiguration().getSignatureSigningConfiguration());
        }
        if (input != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(input.getProfileId())) != null && defaultConfig.getSignatureSigningConfiguration() != null) {
            configs.add(defaultConfig.getSignatureSigningConfiguration());
        }
        configs.add(SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
        return configs;
    }
}

