/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.metrics.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.RatioGauge;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;

public class CoreGaugeSet
implements MetricSet,
MetricFilter {
    @Nonnull
    @NonnullElements
    private final Map<String, Metric> gauges = new HashMap<String, Metric>();

    public CoreGaugeSet() {
        this.gauges.put("os.name", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("os.name");
            }
        });
        this.gauges.put("os.version", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("os.version");
            }
        });
        this.gauges.put("os.arch", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("os.arch");
            }
        });
        this.gauges.put("java.class.path", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("java.class.path");
            }
        });
        this.gauges.put("java.home", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("java.home");
            }
        });
        this.gauges.put("java.vendor", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("java.vendor");
            }
        });
        this.gauges.put("java.vendor.url", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("java.vendor.url");
            }
        });
        this.gauges.put("java.version", (Metric)new Gauge<String>(){

            public String getValue() {
                return System.getProperty("java.version");
            }
        });
        this.gauges.put("cores.available", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return Runtime.getRuntime().availableProcessors();
            }
        });
        this.gauges.put("memory.free.bytes", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        this.gauges.put("memory.free.megs", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().freeMemory() / 0x100000L;
            }
        });
        this.gauges.put("memory.used.bytes", (Metric)new Gauge<Long>(){

            public Long getValue() {
                Runtime runtime = Runtime.getRuntime();
                return runtime.totalMemory() - runtime.freeMemory();
            }
        });
        this.gauges.put("memory.used.megs", (Metric)new Gauge<Long>(){

            public Long getValue() {
                Runtime runtime = Runtime.getRuntime();
                return (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
            }
        });
        this.gauges.put("memory.usage", (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                Runtime runtime = Runtime.getRuntime();
                return RatioGauge.Ratio.of((double)(runtime.totalMemory() - runtime.freeMemory()), (double)runtime.totalMemory());
            }
        });
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.gauges);
    }

    public boolean matches(String name, Metric metric) {
        return this.gauges.containsKey(name);
    }
}

