/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class UsernamePrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String username;

    public UsernamePrincipal(@Nonnull @ParameterName(name="user") @NotEmpty String user) {
        this.username = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)user), (String)"Username cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getName() {
        return this.username;
    }

    @Override
    public int hashCode() {
        return this.username.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof UsernamePrincipal) {
            return this.username.equals(((UsernamePrincipal)other).getName());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", (Object)this.username).toString();
    }

    @Override
    public UsernamePrincipal clone() throws CloneNotSupportedException {
        UsernamePrincipal copy = (UsernamePrincipal)super.clone();
        copy.username = this.username;
        return copy;
    }
}

