/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class ProxyAuthenticationPrincipal
implements Principal {
    @Nonnull
    @NonnullElements
    private Collection<String> authorities;

    public ProxyAuthenticationPrincipal() {
        this.authorities = new ArrayList<String>();
    }

    public ProxyAuthenticationPrincipal(@Nonnull @NonnullElements Collection<String> proxiedAuthorities) {
        Constraint.isNotNull(proxiedAuthorities, (String)"Proxied authority collection cannot be null");
        this.authorities = new ArrayList<String>(Collections2.filter(proxiedAuthorities, (Predicate)Predicates.notNull()));
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getName() {
        return this.authorities.toString();
    }

    @Nonnull
    @NonnullElements
    @Live
    public Collection<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    public int hashCode() {
        return this.authorities.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof ProxyAuthenticationPrincipal) {
            return this.authorities.equals(((ProxyAuthenticationPrincipal)other).getAuthorities());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authorities", this.authorities).toString();
    }
}

