/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.LoggerFactory;

public class MultiFactorAuthenticationTransition {
    @Nonnull
    @NonnullElements
    private Map<String, Function<ProfileRequestContext, String>> nextFlowStrategyMap = new HashMap<String, Function<ProfileRequestContext, String>>();

    @Nonnull
    public Function<ProfileRequestContext, String> getNextFlowStrategy(@Nonnull @NotEmpty String event) {
        if (this.nextFlowStrategyMap.containsKey(event)) {
            return this.nextFlowStrategyMap.get(event);
        }
        return FunctionSupport.constant(null);
    }

    @Nonnull
    @NonnullElements
    @Live
    Map<String, Function<ProfileRequestContext, String>> getNextFlowStrategyMap() {
        return this.nextFlowStrategyMap;
    }

    public void setNextFlowStrategyMap(@Nonnull @NonnullElements Map<String, Object> map) {
        Constraint.isNotNull(map, (String)"Transition strategy map cannot be null");
        this.nextFlowStrategyMap.clear();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String trimmed = StringSupport.trimOrNull((String)entry.getKey());
            if (trimmed == null) continue;
            if (entry.getValue() instanceof String) {
                String flowId = StringSupport.trimOrNull((String)((String)entry.getValue()));
                if (flowId == null) continue;
                this.nextFlowStrategyMap.put(trimmed, (Function<ProfileRequestContext, String>)FunctionSupport.constant((Object)flowId));
                continue;
            }
            if (entry.getValue() instanceof Function) {
                this.nextFlowStrategyMap.put(trimmed, (Function<ProfileRequestContext, String>)((Function)entry.getValue()));
                continue;
            }
            if (entry.getValue() == null) continue;
            LoggerFactory.getLogger(MultiFactorAuthenticationTransition.class).warn("Ignoring mapping from {} to unsupported object of type {}", (Object)trimmed, entry.getValue().getClass());
        }
    }

    public void setNextFlow(@Nullable @NotEmpty String flowId) {
        this.setNextFlowStrategyMap(Collections.singletonMap("proceed", flowId));
    }

    public void setNextFlowStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        Constraint.isNotNull(strategy, (String)"Flow strategy function cannot be null");
        this.setNextFlowStrategyMap(Collections.singletonMap("proceed", strategy));
    }
}

