/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.Function;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultPrincipalDeterminationStrategy<T extends Principal>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private final Class<T> principalType;
    @Nonnull
    private final T defaultPrincipal;
    @Nonnull
    @NonnullElements
    private Map<T, Integer> weightMap;
    @Nonnull
    private Function<ProfileRequestContext, AuthenticationContext> authnContextLookupStrategy;

    public DefaultPrincipalDeterminationStrategy(@Nonnull @ParameterName(name="type") Class<T> type, @Nonnull @ParameterName(name="principal") T principal) {
        this.principalType = (Class)Constraint.isNotNull(type, (String)"Class type cannot be null");
        this.defaultPrincipal = (Principal)Constraint.isNotNull(principal, (String)"Default Principal cannot be null");
        this.weightMap = Collections.emptyMap();
        this.authnContextLookupStrategy = new ChildContextLookup(AuthenticationContext.class, false);
    }

    public void setWeightMap(@Nullable @NonnullElements Map<T, Integer> map) {
        if (map == null) {
            this.weightMap = Collections.emptyMap();
            return;
        }
        this.weightMap = new HashMap<T, Integer>(map.size());
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.weightMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void setAuthenticationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContext> strategy) {
        this.authnContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        AuthenticationContext ac = (AuthenticationContext)((Object)this.authnContextLookupStrategy.apply((Object)input));
        if (ac == null || ac.getAuthenticationResult() == null) {
            return this.defaultPrincipal;
        }
        Set<T> principals = ac.getAuthenticationResult().getSupportedPrincipals(this.principalType);
        if (principals.isEmpty()) {
            return this.defaultPrincipal;
        }
        if (principals.size() == 1 || this.weightMap.isEmpty()) {
            return (T)((Principal)principals.iterator().next());
        }
        Object[] principalArray = principals.toArray();
        Arrays.sort(principalArray, new WeightedComparator());
        return (T)((Principal)principalArray[principalArray.length - 1]);
    }

    private class WeightedComparator
    implements Comparator {
        private WeightedComparator() {
        }

        public int compare(Object o1, Object o2) {
            int weight2;
            int weight1 = DefaultPrincipalDeterminationStrategy.this.weightMap.containsKey(o1) ? (Integer)DefaultPrincipalDeterminationStrategy.this.weightMap.get(o1) : 0;
            int n = weight2 = DefaultPrincipalDeterminationStrategy.this.weightMap.containsKey(o2) ? (Integer)DefaultPrincipalDeterminationStrategy.this.weightMap.get(o2) : 0;
            if (weight1 < weight2) {
                return -1;
            }
            if (weight1 > weight2) {
                return 1;
            }
            return 0;
        }
    }
}

