/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractResolverPlugin;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractAttributeDefinition
extends AbstractResolverPlugin<IdPAttribute>
implements AttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributeDefinition.class);
    private boolean dependencyOnly;
    @Nullable
    private String sourceAttributeID;
    @Nonnull
    private Set<AttributeEncoder<?>> encoders = Collections.emptySet();
    @Nonnull
    private Map<Locale, String> displayNames = Collections.emptyMap();
    @Nonnull
    private Map<Locale, String> displayDescriptions = Collections.emptyMap();
    @Nullable
    private String logPrefix;

    @Override
    public boolean isDependencyOnly() {
        return this.dependencyOnly;
    }

    public void setDependencyOnly(boolean isDependencyOnly) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.dependencyOnly = isDependencyOnly;
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayDescriptions() {
        return this.displayDescriptions;
    }

    public void setDisplayDescriptions(@Nullable @NullableElements Map<Locale, String> descriptions) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        HashMap<Locale, String> checkedDescriptions = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String> entry : descriptions.entrySet()) {
            String trimmedDescription = StringSupport.trimOrNull((String)entry.getValue());
            if (trimmedDescription == null) continue;
            checkedDescriptions.put(entry.getKey(), trimmedDescription);
        }
        this.displayDescriptions = ImmutableMap.copyOf(checkedDescriptions);
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    public void setDisplayNames(@Nullable @NullableElements Map<Locale, String> names) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        HashMap<Locale, String> checkedNames = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String> entry : names.entrySet()) {
            String trimmedName = StringSupport.trimOrNull((String)entry.getValue());
            if (trimmedName == null) continue;
            checkedNames.put(entry.getKey(), trimmedName);
        }
        this.displayNames = ImmutableMap.copyOf(checkedNames);
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Set<AttributeEncoder<?>> getAttributeEncoders() {
        return this.encoders;
    }

    public void setAttributeEncoders(@Nullable @NullableElements Set<AttributeEncoder<?>> attributeEncoders) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        HashSet checkedEncoders = new HashSet();
        CollectionSupport.addIf(checkedEncoders, attributeEncoders, (Predicate)Predicates.notNull());
        this.encoders = ImmutableSet.copyOf(checkedEncoders);
    }

    @Deprecated
    public String getSourceAttributeId() {
        return this.sourceAttributeID;
    }

    public void setSourceAttributeId(String attributeId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sourceAttributeID = StringSupport.trimOrNull((String)attributeId);
    }

    private boolean hasDeprecatedId() {
        String id = StringSupport.trimOrNull((String)this.getId());
        return id == null || id.indexOf(39) >= 0 || id.indexOf(37) >= 0 || id.indexOf(123) >= 0 || id.indexOf(125) >= 0;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (null != this.getSourceAttributeId()) {
            for (ResolverPluginDependency depends : this.getDependencies()) {
                if (depends instanceof ResolverAttributeDefinitionDependency || depends instanceof ResolverDataConnectorDependency) continue;
                depends.setDependencyAttributeId(this.getSourceAttributeId());
            }
        }
        super.doInitialize();
        this.logPrefix = null;
        if (!Pattern.matches("\\S*", this.getId())) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"Use of IdP Attributes names with spaces in them", (String)this.getLogPrefix(), null);
        }
        if (this.hasDeprecatedId()) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"Use of IdP Attributes names with with special characters (\\'\\\"%{})", (String)this.getLogPrefix(), null);
            this.log.debug("{} - deprecated character in attribute name", (Object)this.getId());
        }
    }

    @Override
    @Nullable
    protected IdPAttribute doResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        IdPAttribute resolvedAttribute = this.doAttributeDefinitionResolve(resolutionContext, workContext);
        if (null == resolvedAttribute) {
            this.log.debug("{} no attribute was produced during resolution", (Object)this.getLogPrefix());
            return null;
        }
        if (resolvedAttribute.getValues().isEmpty()) {
            this.log.debug("{} produced an attribute with no values", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} produced an attribute with the following values {}", (Object)this.getLogPrefix(), (Object)resolvedAttribute.getValues());
        }
        this.log.trace("{} associating the following display descriptions with the resolved attribute: {}", (Object)this.getLogPrefix(), this.getDisplayDescriptions());
        resolvedAttribute.setDisplayDescriptions(this.getDisplayDescriptions());
        this.log.trace("{} associating the following display names with the resolved attribute: {}", (Object)this.getLogPrefix(), this.getDisplayNames());
        resolvedAttribute.setDisplayNames(this.getDisplayNames());
        this.log.trace("{} associating the following encoders with the resolved attribute: {}", (Object)this.getLogPrefix(), this.getAttributeEncoders());
        resolvedAttribute.setEncoders(this.getAttributeEncoders());
        return resolvedAttribute;
    }

    @Nullable
    protected abstract IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Definition '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

