/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import com.google.common.base.Predicate;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public final class ResolvedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final AttributeDefinition resolvedDefinition;
    @Nullable
    private final IdPAttribute resolvedAttribute;

    public ResolvedAttributeDefinition(@Nonnull AttributeDefinition definition, @Nullable IdPAttribute attribute) {
        this.resolvedDefinition = (AttributeDefinition)Constraint.isNotNull((Object)definition, (String)"Resolved attribute definition can not be null");
        Constraint.isTrue((boolean)definition.isInitialized(), (String)"Resolved definition must have been initialized");
        Constraint.isFalse((boolean)definition.isDestroyed(), (String)"Resolved definition can not have been destroyed");
        this.resolvedAttribute = attribute;
    }

    @Override
    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        return this.resolvedAttribute;
    }

    @Override
    public boolean equals(Object obj) {
        return this.resolvedDefinition.equals(obj);
    }

    @Override
    @Nonnull
    @NonnullElements
    public Set<AttributeEncoder<?>> getAttributeEncoders() {
        return this.resolvedDefinition.getAttributeEncoders();
    }

    @Override
    @Nonnull
    @NonnullElements
    public Set<ResolverPluginDependency> getDependencies() {
        return this.resolvedDefinition.getDependencies();
    }

    @Override
    @Nonnull
    @NonnullElements
    public Map<Locale, String> getDisplayDescriptions() {
        return this.resolvedDefinition.getDisplayDescriptions();
    }

    @Override
    @Nonnull
    @NonnullElements
    public Map<Locale, String> getDisplayNames() {
        return this.resolvedDefinition.getDisplayNames();
    }

    @Override
    @Nullable
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return null;
    }

    @Nonnull
    public String getId() {
        return this.resolvedDefinition.getId();
    }

    @Nullable
    public IdPAttribute getResolvedAttribute() {
        return this.resolvedAttribute;
    }

    @Override
    public int hashCode() {
        return this.resolvedDefinition.hashCode();
    }

    @Override
    public boolean isDependencyOnly() {
        return this.resolvedDefinition.isDependencyOnly();
    }

    @Override
    public boolean isPropagateResolutionExceptions() {
        return this.resolvedDefinition.isPropagateResolutionExceptions();
    }

    @Override
    public void setDependencyOnly(boolean isDependencyOnly) {
    }

    @Override
    public void setDisplayDescriptions(Map<Locale, String> descriptions) {
    }

    @Override
    public void setDisplayNames(Map<Locale, String> names) {
    }

    @Override
    public void setPropagateResolutionExceptions(boolean propagate) {
    }

    @Nonnull
    public String toString() {
        return this.resolvedDefinition.toString();
    }

    @Nonnull
    public AttributeDefinition getResolvedDefinition() {
        return this.resolvedDefinition;
    }

    public boolean isInitialized() {
        return true;
    }
}

