/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolvedDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginDependencySupport {
    private static final Logger LOG = LoggerFactory.getLogger(PluginDependencySupport.class);

    private PluginDependencySupport() {
    }

    @Deprecated
    @Nonnull
    @NonnullElements
    public static List<IdPAttributeValue<?>> getMergedAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull @NonnullElements Collection<ResolverPluginDependency> dependencies) {
        Constraint.isNotNull((Object)((Object)workContext), (String)"Attribute resolution context cannot be null");
        Constraint.isNotNull(dependencies, (String)"Resolver dependency collection cannot be null");
        ArrayList values = new ArrayList();
        for (ResolverPluginDependency dependency : dependencies) {
            Constraint.isNotNull((Object)dependency, (String)"Resolver dependency cannot be null");
            ResolvedAttributeDefinition attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(dependency.getDependencyPluginId());
            if (attributeDefinition != null) {
                IdPAttribute resolvedAttribute = attributeDefinition.getResolvedAttribute();
                PluginDependencySupport.addAttributeValues(resolvedAttribute, values);
                continue;
            }
            ResolvedDataConnector dataConnector = workContext.getResolvedDataConnectors().get(dependency.getDependencyPluginId());
            if (dataConnector == null) continue;
            if (dependency.getDependencyAttributeId() == null) {
                LOG.error("Data connector dependencies must specify a dependant attribute ID");
                return Collections.EMPTY_LIST;
            }
            if (null == dataConnector.getResolvedAttributes()) continue;
            IdPAttribute resolvedAttribute = dataConnector.getResolvedAttributes().get(dependency.getDependencyAttributeId());
            PluginDependencySupport.addAttributeValues(resolvedAttribute, values);
        }
        return values;
    }

    @Nonnull
    @NonnullElements
    public static List<IdPAttributeValue<?>> getMergedAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull @NonnullElements Collection<ResolverPluginDependency> dependencies, @Nonnull String attributeDefinitionId) {
        Constraint.isNotNull((Object)((Object)workContext), (String)"Attribute resolution context cannot be null");
        Constraint.isNotNull(dependencies, (String)"Resolver dependency collection cannot be null");
        ArrayList values = new ArrayList();
        for (ResolverPluginDependency dependency : dependencies) {
            Constraint.isNotNull((Object)dependency, (String)"Resolver dependency cannot be null");
            String pluginId = dependency.getDependencyPluginId();
            ResolvedAttributeDefinition attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(pluginId);
            String dependencyAttributeId = dependency.getDependencyAttributeId();
            if (attributeDefinition != null) {
                if (null == dependencyAttributeId) {
                    LOG.warn("Plugin '{}' was defined without a sourceAttributeID,  but attribute '{}', specified as a <Dependency> will be used.", (Object)attributeDefinitionId, (Object)pluginId);
                } else if (!dependencyAttributeId.equals(pluginId)) {
                    LOG.warn("Plugin '{}' was defined with a sourceAttributeID '{}', but the attribute definition '{}', specified as a <Dependency> will be used as well.", new Object[]{attributeDefinitionId, dependencyAttributeId, pluginId});
                }
                IdPAttribute resolvedAttribute = attributeDefinition.getResolvedAttribute();
                PluginDependencySupport.addAttributeValues(resolvedAttribute, values);
                continue;
            }
            ResolvedDataConnector dataConnector = workContext.getResolvedDataConnectors().get(dependency.getDependencyPluginId());
            if (dataConnector == null) continue;
            if (dependency.getDependencyAttributeId() == null) {
                LOG.error("Attribute definition '{}' has a data connector dependency '{}' but no sourceAttributeID.", (Object)attributeDefinitionId, (Object)dataConnector.getId());
                return Collections.EMPTY_LIST;
            }
            if (null == dataConnector.getResolvedAttributes()) continue;
            IdPAttribute resolvedAttribute = dataConnector.getResolvedAttributes().get(dependency.getDependencyAttributeId());
            PluginDependencySupport.addAttributeValues(resolvedAttribute, values);
        }
        return values;
    }

    public static Map<String, List<IdPAttributeValue<?>>> getAllAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull Collection<ResolverPluginDependency> dependencies) {
        HashMap result = new HashMap();
        for (ResolverPluginDependency dependency : dependencies) {
            Constraint.isNotNull((Object)dependency, (String)"Resolver dependency cannot be null");
            ResolvedAttributeDefinition attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(dependency.getDependencyPluginId());
            if (attributeDefinition != null) {
                PluginDependencySupport.addAttributeValues(attributeDefinition.getResolvedAttribute(), result);
                continue;
            }
            ResolvedDataConnector dataConnector = workContext.getResolvedDataConnectors().get(dependency.getDependencyPluginId());
            if (dataConnector == null || null == dataConnector.getResolvedAttributes()) continue;
            PluginDependencySupport.addAttributeValues(dataConnector.getResolvedAttributes(), result);
        }
        return result;
    }

    @Nonnull
    private static void addAttributeValues(@Nonnull Map<String, IdPAttribute> sources, @Nullable Map<String, List<IdPAttributeValue<?>>> target) {
        for (IdPAttribute source : sources.values()) {
            if (source == null) continue;
            PluginDependencySupport.addAttributeValues(source, target);
        }
    }

    @Nonnull
    private static void addAttributeValues(@Nullable IdPAttribute source, @Nullable Map<String, List<IdPAttributeValue<?>>> target) {
        if (source == null) {
            return;
        }
        List<IdPAttributeValue<?>> attributeValues = target.get(source.getId());
        if (attributeValues == null) {
            attributeValues = new ArrayList();
            target.put(source.getId(), attributeValues);
        }
        PluginDependencySupport.addAttributeValues(source, attributeValues);
    }

    @Nonnull
    private static void addAttributeValues(@Nullable IdPAttribute source, @Nonnull List<IdPAttributeValue<?>> target) {
        if (source != null) {
            target.addAll(source.getValues());
        }
    }
}

