/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@ThreadSafe
public abstract class AbstractResolverPlugin<ResolvedType>
extends AbstractIdentifiableInitializableComponent
implements ResolverPlugin<ResolvedType>,
DisposableBean {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractResolverPlugin.class);
    private boolean propagateResolutionExceptions = true;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> profileContextStrategy = new ParentContextLookup();
    @Nullable
    private Predicate<ProfileRequestContext> activationCondition;
    @Nonnull
    @NonnullElements
    private Set<ResolverPluginDependency> dependencies = Collections.emptySet();

    @Override
    public boolean isPropagateResolutionExceptions() {
        return this.propagateResolutionExceptions;
    }

    public void setPropagateResolutionExceptions(boolean propagate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.propagateResolutionExceptions = propagate;
    }

    public void setProfileContextStrategy(Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile Context Strategy cannot be null");
    }

    public Function<AttributeResolutionContext, ProfileRequestContext> getProfileContextStrategy() {
        return this.profileContextStrategy;
    }

    @Override
    @Nullable
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> pred) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(pred, (String)"Activiation condition cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Set<ResolverPluginDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(@Nullable @NullableElements Set<ResolverPluginDependency> pluginDependencies) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        HashSet checkedDeps = new HashSet();
        CollectionSupport.addIf(checkedDeps, pluginDependencies, (Predicate)Predicates.notNull());
        this.dependencies = Collections.unmodifiableSet(checkedDeps);
    }

    @Override
    @Nullable
    public final ResolvedType resolve(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        ProfileRequestContext profileRequestContext;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)((Object)resolutionContext), (String)"AttributeResolutionContext cannot be null");
        if (null != this.activationCondition && !this.activationCondition.apply((Object)(profileRequestContext = (ProfileRequestContext)this.profileContextStrategy.apply((Object)resolutionContext)))) {
            this.log.debug("Resolver plugin '{}': activation criteria not met, nothing to do", (Object)this.getId());
            return null;
        }
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        Constraint.isNotNull((Object)((Object)workContext), (String)"AttributeResolverWorkContext cannot be null");
        try {
            ResolvedType result = this.doResolve(resolutionContext, workContext);
            if (null == result) {
                this.log.info("Resolver plugin '{}' produced no value.", (Object)this.getId());
            }
            return result;
        }
        catch (ResolutionException e) {
            if (this.propagateResolutionExceptions) {
                throw e;
            }
            this.log.debug("Resolver plugin '{}' produced the following error but was configured not to propagate it.", (Object)this.getId(), (Object)e);
            return null;
        }
    }

    protected void doDestroy() {
        this.activationCondition = Predicates.alwaysFalse();
        this.dependencies = Collections.emptySet();
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        HashSet<ResolverPluginDependency> checkedDeps = new HashSet<ResolverPluginDependency>(this.dependencies);
        this.dependencies = ImmutableSet.copyOf(checkedDeps);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getId()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractResolverPlugin)) {
            return false;
        }
        AbstractResolverPlugin other = (AbstractResolverPlugin)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    @Nullable
    protected abstract ResolvedType doResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;
}

