/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.context;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.messaging.context.BaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AttributeContext
extends BaseContext {
    @Nonnull
    private Map<String, IdPAttribute> attributes = Collections.emptyMap();
    @Nullable
    private Map<String, IdPAttribute> unfilteredAttributes;
    private final Logger log = LoggerFactory.getLogger(AttributeContext.class);

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, IdPAttribute> getIdPAttributes() {
        return this.attributes;
    }

    public void setIdPAttributes(@Nullable @NullableElements Collection<IdPAttribute> newAttributes) {
        if (newAttributes == null) {
            this.attributes = Collections.emptyMap();
            return;
        }
        HashMap<String, IdPAttribute> checkedAttributes = new HashMap<String, IdPAttribute>();
        for (IdPAttribute attribute : newAttributes) {
            if (attribute == null) continue;
            checkedAttributes.put(attribute.getId(), attribute);
        }
        this.attributes = ImmutableMap.copyOf(checkedAttributes);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, IdPAttribute> getUnfilteredIdPAttributes() {
        if (null == this.unfilteredAttributes) {
            this.log.error("No Attributes have been set in this flow.");
            return Collections.emptyMap();
        }
        return this.unfilteredAttributes;
    }

    public void setUnfilteredIdPAttributes(@Nullable @NullableElements Collection<IdPAttribute> newAttributes) {
        if (null != this.unfilteredAttributes) {
            this.log.error("Unfiltered attributes have already been set in this flow.");
        }
        if (newAttributes == null) {
            this.unfilteredAttributes = Collections.emptyMap();
            return;
        }
        HashMap<String, IdPAttribute> checkedAttributes = new HashMap<String, IdPAttribute>();
        for (IdPAttribute attribute : newAttributes) {
            if (attribute == null) continue;
            checkedAttributes.put(attribute.getId(), attribute);
        }
        this.unfilteredAttributes = ImmutableMap.copyOf(checkedAttributes);
    }
}

