/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.test;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.rdl.DefaultTheory;
import net.sf.tweety.logics.rdl.parser.RdlParser;
import net.sf.tweety.logics.rdl.semantics.DefaultSequence;
import net.sf.tweety.logics.rdl.syntax.DefaultRule;

public class RDLTest {
    static List<DefaultRule> createTestSet(RdlParser parser, String ... list) throws Exception {
        LinkedList<DefaultRule> result = new LinkedList<DefaultRule>();
        for (String str : list) {
            result.add((DefaultRule)parser.parseFormula(str));
        }
        return result;
    }

    static void defaultRuleTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory th = (DefaultTheory)parser.parseBeliefBaseFromFile("example_default_theory.txt");
        List<DefaultRule> testset = RDLTest.createTestSet(parser, "Bird(A)::Flies(A)/Flies(A)", "::! Swims(A)/Flies(A)", ":: Flies(B)/Flies(A)", "exists X: (Flies(X)) :: Flies(B); !Swims(B)  / Flies(B)", "Married(A,B)::Female(A)/Male(B)", "Married(A,B)::Female(A);Male(B)/Male(B)", "Father(A,B) :: Married(A,C) / Mother(C,B) ", "::(forall X: (Male(X)))/(exists Y:(Male(Y)))", "exists Z:(Married(X,Z))::Male(X)  / exists Y:(Father(X,Y))");
        System.out.println("\n--isNormal--");
        for (DefaultRule d : testset) {
            System.out.print((Object)d);
            System.out.println("\t\t" + (d.isNormal(th) ? "normal" : "not normal"));
        }
        System.out.println("\n--getUnboundVariables--");
        for (DefaultRule d : testset) {
            Set<Variable> vs = d.getUnboundVariables();
            System.out.print((Object)((Object)d) + "\t\t{");
            for (Variable v : vs) {
                System.out.print(v);
            }
            System.out.println("}");
        }
    }

    static void parserTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory th = (DefaultTheory)parser.parseBeliefBaseFromFile("example_default_theory.txt");
        System.out.println(th);
        DefaultRule d = (DefaultRule)parser.parseFormula("exists X:(Flies(X))::Flies(B)/Flies(B)");
        System.out.println((Object)d);
    }

    static void sequenceTest() throws Exception {
        RdlParser parser = new RdlParser();
        DefaultTheory th = (DefaultTheory)parser.parseBeliefBaseFromFile("example_default_theory.txt");
        DefaultSequence s = new DefaultSequence(th);
        System.out.println(s);
        s = s.app((DefaultRule)parser.parseFormula("::!Flies(X)/!Flies(X)"));
        System.out.println(s);
    }

    public static void main(String[] args) throws Exception {
        RDLTest.sequenceTest();
    }
}

