/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.fol.ClassicalInference;
import net.sf.tweety.logics.fol.FolBeliefSet;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.Negation;
import net.sf.tweety.logics.fol.syntax.RelationalFormula;
import net.sf.tweety.logics.rdl.DefaultTheory;
import net.sf.tweety.logics.rdl.syntax.DefaultRule;

public class DefaultSequence {
    private List<DefaultRule> defaults = new ArrayList<DefaultRule>();
    private Set<FolFormula> out = new HashSet<FolFormula>();
    private FolBeliefSet in = new FolBeliefSet();
    private ClassicalInference reasoner = new ClassicalInference((BeliefBase)this.in);
    boolean process = true;

    public DefaultSequence(DefaultTheory dt) {
        this.in.addAll((Collection)dt.getFacts());
    }

    public DefaultSequence(DefaultSequence ds, DefaultRule d) {
        this.defaults.addAll(ds.defaults);
        this.defaults.add(d);
        this.in.addAll((Collection)ds.in);
        this.process = false;
        for (FolFormula f : this.in) {
            if (!this.eq(f, d.getPre())) continue;
            this.process = true;
        }
        for (DefaultRule r : this.defaults) {
            if (d != r) continue;
            this.process = false;
        }
        this.in.add((Formula)d.getConc());
        this.out.addAll(ds.out);
        for (FolFormula f : d.getJus()) {
            this.out.add((FolFormula)new Negation((RelationalFormula)f));
        }
    }

    public DefaultSequence app(DefaultRule d) {
        return new DefaultSequence(this, d);
    }

    private boolean eq(FolFormula a, FolFormula b) {
        return ClassicalInference.equivalent((FolFormula)a, (FolFormula)b);
    }

    public Collection<FolFormula> getIn() {
        return this.in;
    }

    public Collection<FolFormula> getOut() {
        return this.out;
    }

    public boolean isProcess() {
        return this.process;
    }

    public boolean isSuccessful() {
        for (FolFormula f : this.in) {
            for (FolFormula g : this.out) {
                if (!this.eq(f, g)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isClosed() {
        return false;
    }

    public String toString() {
        return "DefaultSequence [\n\tdefaults = " + this.defaults + ", \n\tout = " + this.out + ", \n\tin = " + this.in + "\n\tprocess = " + this.process + "\n]";
    }
}

