/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.logics.fol.syntax.FolBeliefSet;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.logics.rdl.syntax.DefaultRule;

public class DefaultTheory
implements BeliefBase {
    private FolBeliefSet facts;
    private Collection<DefaultRule> defaults;

    public DefaultTheory() {
        this.facts = new FolBeliefSet();
        this.defaults = new ArrayList<DefaultRule>();
    }

    public DefaultTheory(FolBeliefSet facts, Collection<DefaultRule> defaults) {
        this.facts = facts;
        this.defaults = new ArrayList<DefaultRule>();
        this.defaults.addAll(defaults);
    }

    void addFact(FolFormula fact) {
        this.facts.add((Formula)fact);
    }

    void removeFact(FolFormula fact) {
        this.facts.remove((Object)fact);
    }

    void addDefault(DefaultRule d) {
        this.defaults.add(d);
    }

    void removeDefault(DefaultRule d) {
        this.defaults.remove((Object)d);
    }

    public Collection<DefaultRule> getDefaults() {
        return this.defaults;
    }

    public DefaultTheory ground() {
        HashSet<DefaultRule> ds = new HashSet<DefaultRule>();
        for (DefaultRule d : this.defaults) {
            ds.addAll(d.allGroundInstances(((FolSignature)this.getMinimalSignature()).getConstants()));
        }
        return new DefaultTheory(this.facts, ds);
    }

    public Signature getMinimalSignature() {
        FolSignature result = this.facts.getMinimalSignature();
        for (DefaultRule d : this.defaults) {
            result.addSignature((Signature)d.getSignature());
        }
        return result;
    }

    public String toString() {
        String result = this.facts + "\n\n";
        for (DefaultRule d : this.defaults) {
            result = result + d + "\n";
        }
        return result;
    }

    public FolBeliefSet getFacts() {
        return this.facts;
    }
}

